/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509.attr;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.x509.CommonCertificate;
import de.intarsys.asn1.x509.attr.AttributeCertificateInfo;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;

public class AttributeCertificate
extends CommonCertificate {
    public static final Factory FACTORY = new Factory();

    public AttributeCertificateInfo getAttributeCertificateInfo() {
        return (AttributeCertificateInfo)AttributeCertificateInfo.FACTORY.create(this.getValueHolder().getChild(0));
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(this.getValueHolder().getChild(1));
    }

    public byte[] getSignatureValue() {
        return this.getValueHolder().getChild(2).toDERBitString().getBytes();
    }

    @Override
    public boolean isAttributeCertificate() {
        return true;
    }

    public void setAttributeCertificateInfo(AttributeCertificateInfo tbsCert) {
        this.getValueHolder().setChild(0, tbsCert);
    }

    public void setSignatureAlgorithm(AlgorithmIdentifier signatureAlgo) {
        this.getValueHolder().setChild(1, signatureAlgo);
    }

    public void setSignatureValue(byte[] signatureValue) {
        this.getValueHolder().setChild(2, (ASN1Encodable)new DERBitString(signatureValue));
    }

    public static class Factory
    extends CommonCertificate.Factory<AttributeCertificate> {
    }
}

