/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;

public class Extension
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public ASN1OctetString asn1GetValue() {
        return this.getValueHolder().getNextTyped(1, ASN1OctetString.class).toDEROctetString();
    }

    public String getId() {
        return this.getValueHolder().getChild(0).toDERObjectIdentifier().getId();
    }

    public byte[] getValue() {
        return this.asn1GetValue().getOctets();
    }

    public boolean isCritical() {
        ASN1ValueHolder object = this.getValueHolder().getNextTyped(1, ASN1Boolean.class);
        return object == null ? false : object.toDERBoolean().isTrue();
    }

    protected boolean isCriticalExistent() {
        ASN1ValueHolder object = this.getValueHolder().getNextTyped(1, ASN1Boolean.class);
        return object != null;
    }

    public void setCritical(boolean critical) {
        if (critical) {
            if (this.isCriticalExistent()) {
                this.getValueHolder().setChild(1, (ASN1Encodable)ASN1Boolean.getInstance((boolean)critical));
            } else {
                this.getValueHolder().insertChild(1, (ASN1Encodable)ASN1Boolean.getInstance((boolean)critical));
            }
        } else if (this.isCriticalExistent()) {
            this.getValueHolder().setChild(1, (ASN1Encodable)ASN1Boolean.getInstance((boolean)critical));
        }
    }

    public void setId(String id) {
        this.getValueHolder().setChild(0, (ASN1Encodable)new ASN1ObjectIdentifier(id));
    }

    public void setValue(byte[] value) {
        int index = 1;
        if (this.isCriticalExistent()) {
            ++index;
        }
        this.getValueHolder().setChild(index, (ASN1Encodable)new DEROctetString(value));
    }

    public static class Factory
    extends ASN1Based.Factory<Extension> {
    }
}

