/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.policy;

import de.intarsys.asn1.common.DirectoryString;
import de.intarsys.asn1.common.GeneralNames;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.policy.SignPolExtensions;
import de.intarsys.asn1.policy.SignatureValidationPolicy;
import java.text.ParseException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignPolicyInfo
extends ASN1Based {
    private static final Logger Log = LoggerFactory.getLogger(SignPolicyInfo.class);
    public static final Factory FACTORY = new Factory();

    public Date getDateOfIssue() {
        ASN1GeneralizedTime value = ASN1GeneralizedTime.getInstance((Object)this.getValueHolder().getChild(1).toASN1Primitive());
        try {
            return value.getDate();
        }
        catch (ParseException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getFieldOfApplication() {
        return ((DirectoryString)DirectoryString.FACTORY.create(this.getValueHolder().getChild(3))).getString();
    }

    public GeneralNames getPolicyIssuerName() {
        return (GeneralNames)GeneralNames.FACTORY.create(this.getValueHolder().getChild(2));
    }

    public SignatureValidationPolicy getSignatureValidationPolicy() {
        return (SignatureValidationPolicy)SignatureValidationPolicy.FACTORY.create(this.getValueHolder().getChild(4));
    }

    public SignPolExtensions getSignPolExtensions() {
        if (this.size() < 6) {
            return null;
        }
        return (SignPolExtensions)SignPolExtensions.FACTORY.create(this.getValueHolder().getChild(5));
    }

    public String getSignPolicyIdentifier() {
        return this.getValueHolder().getChild(0).toDERObjectIdentifier().getId();
    }

    public static class Factory
    extends ASN1Based.Factory<SignPolicyInfo> {
    }
}

