/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.policy;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.policy.AlgorithmConstraintSet;
import de.intarsys.asn1.policy.AttributeTrustCondition;
import de.intarsys.asn1.policy.SelectedCommitmentType;
import de.intarsys.asn1.policy.SignPolExtensions;
import de.intarsys.asn1.policy.SignerAndVerifierRules;
import de.intarsys.asn1.policy.SigningCertTrustCondition;
import de.intarsys.asn1.policy.TimestampTrustCondition;
import org.bouncycastle.asn1.ASN1Null;

public class CommitmentRule
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public SelectedCommitmentType[] getSelectedCommitmentTypes() {
        ASN1ValueHolder commitmentTypesSequence = this.getValueHolder().getChild(0);
        SelectedCommitmentType[] commitmentTypes = new SelectedCommitmentType[commitmentTypesSequence.size()];
        for (int i = 0; i < commitmentTypes.length; ++i) {
            ASN1ValueHolder commitmentType = commitmentTypesSequence.getChild(i);
            if (!(commitmentType.toASN1Primitive() instanceof ASN1Null)) continue;
            commitmentTypes[i] = (SelectedCommitmentType)SelectedCommitmentType.FACTORY.create(commitmentTypesSequence.getChild(i));
        }
        return commitmentTypes;
    }

    public AlgorithmConstraintSet getAlgorithmConstraintSet() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(1, 4, true);
        if (vh == null) {
            return null;
        }
        return (AlgorithmConstraintSet)AlgorithmConstraintSet.FACTORY.create(vh);
    }

    public AttributeTrustCondition getAttributeTrustCondition() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(1, 3, true);
        if (vh == null) {
            return null;
        }
        return (AttributeTrustCondition)AttributeTrustCondition.FACTORY.create(vh);
    }

    public SignerAndVerifierRules getSignerAndVerifierRules() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(1, 0, true);
        if (vh == null) {
            return null;
        }
        return (SignerAndVerifierRules)SignerAndVerifierRules.FACTORY.create(vh);
    }

    public SigningCertTrustCondition getSigningCertTrustCondition() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(1, 1, true);
        if (vh == null) {
            return null;
        }
        return (SigningCertTrustCondition)SigningCertTrustCondition.FACTORY.create(vh);
    }

    public SignPolExtensions getSignPolExtensions() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(1, 5, true);
        if (vh == null) {
            return null;
        }
        return (SignPolExtensions)SignPolExtensions.FACTORY.create(vh);
    }

    public TimestampTrustCondition getTimestampTrustCondition() {
        ASN1ValueHolder vh = this.getValueHolder().getNextTaggedGetChild(1, 2, true);
        if (vh == null) {
            return null;
        }
        return (TimestampTrustCondition)TimestampTrustCondition.FACTORY.create(vh);
    }

    public static class Factory
    extends ASN1Based.Factory<CommitmentRule> {
    }
}

