/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.model;

import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.collection.SingleObjectIterator;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERTaggedObject;

public class ASN1TaggedHolder
extends ASN1ValueHolder {
    private ASN1ValueHolder nested;
    private final int tagClass;
    private final int tagNo;
    private Boolean explicit;

    protected ASN1TaggedHolder(ASN1TaggedObject value) {
        super((ASN1Primitive)value);
        this.tagClass = value.getTagClass();
        this.tagNo = value.getTagNo();
    }

    public ASN1TaggedHolder(boolean explicit, int tagNo, ASN1Encodable value) {
        this(explicit, 128, tagNo, value);
    }

    public ASN1TaggedHolder(boolean explicit, int tagClass, int tagNo, ASN1Encodable value) {
        this.setChanged(true);
        this.setChild(value);
        this.tagClass = tagClass;
        this.tagNo = tagNo;
        this.explicit = explicit;
    }

    @Override
    public void addChild(ASN1Encodable object) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ASN1Primitive createASN1Primitive() {
        return new DERTaggedObject(this.isExplicit(), this.tagClass, this.getTagNo(), (ASN1Encodable)this.getChild().toASN1Primitive());
    }

    protected ASN1ValueHolder createNested() {
        ASN1ValueHolder baseObject = this.getValue().isExplicit() && !this.isExplicit() ? ASN1ValueHolder.create((ASN1Encodable)this.getValue().getBaseUniversal(this.isExplicit(), 16)) : ASN1ValueHolder.create((ASN1Encodable)this.getValue().getBaseObject());
        return baseObject;
    }

    @Override
    public ASN1ValueHolder getChild() {
        if (this.nested == null) {
            this.nested = this.createNested();
            this.nested.setContainer(this);
        }
        return this.nested;
    }

    @Override
    public ASN1ValueHolder getChild(int index) {
        throw new UnsupportedOperationException();
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public ASN1TaggedObject getValue() {
        return (ASN1TaggedObject)super.getValue();
    }

    @Override
    public void insertChild(int index, ASN1Encodable asn1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isChanged() {
        if (this.nested == null) {
            return super.isChanged();
        }
        return super.isChanged() || this.nested.isChanged();
    }

    @Override
    public boolean isExplicit() {
        if (this.explicit == null) {
            return this.getValue().isExplicit();
        }
        return this.explicit;
    }

    @Override
    public boolean isTagged() {
        return true;
    }

    @Override
    public Iterator<ASN1ValueHolder> iterator() {
        return new SingleObjectIterator((Object)this.getChild());
    }

    @Override
    public void setChild(ASN1Encodable newValue) {
        this.setChanged(true);
        this.nested = ASN1ValueHolder.create(newValue);
        if (this.nested != null) {
            this.nested.setContainer(this);
        }
    }

    @Override
    public void setChild(int index, ASN1Encodable asn1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExplicit(boolean value) {
        this.explicit = value;
    }

    @Override
    public int size() {
        return 1;
    }

    public ASN1TaggedObject toASN1Primitive() {
        return (ASN1TaggedObject)super.toASN1Primitive();
    }
}

