/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.model;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.collection.ListTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;

public class ASN1BasedTools {
    public static <T extends ASN1Based> T create(ASN1Based.Factory<T> factory, byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        return ASN1BasedTools.create(factory, new ByteArrayInputStream(data));
    }

    public static <T extends ASN1Based> T create(ASN1Based.Factory<T> factory, InputStream in) throws IOException {
        ASN1Primitive wrappedObject = ASN1Tools.create(in);
        return factory.create((ASN1Encodable)wrappedObject);
    }

    public static <T extends ASN1Based> T[] createAll(ASN1Based.Factory<T> factory, Iterator<ASN1ValueHolder> encodables) {
        return ASN1BasedTools.createAll(factory, (List)ListTools.toList(encodables));
    }

    public static <T extends ASN1Based> T[] createAll(ASN1Based.Factory<T> factory, List<ASN1ValueHolder> encodables) {
        ASN1Based[] array = (ASN1Based[])Array.newInstance(factory.getInstanceClass(), encodables.size());
        for (int i = 0; i < array.length; ++i) {
            array[i] = factory.create(encodables.get(i));
        }
        return array;
    }
}

