/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.ers;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.ers.PartialHashtree;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1SequenceHolder;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.attr.Attributes;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class ArchiveTimeStamp
extends ASN1Based {
    public static final Factory FACTORY = new Factory();
    private boolean taggingModeExplicit = false;

    public Attributes getAttributes() {
        ASN1ValueHolder value = this.getNextTaggedGetChild(0, 1);
        return (Attributes)Attributes.FACTORY.create(value);
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        ASN1ValueHolder value = this.getNextTaggedGetChild(0, 0);
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(value);
    }

    protected ASN1ValueHolder getNextTaggedGetChild(int start, int tagNo) {
        return this.getValueHolder().getNextTaggedGetChild(start, tagNo, this.taggingModeExplicit);
    }

    public PartialHashtree[] getReducedHashtree() {
        ASN1SequenceHolder partialHashtreeSequence = (ASN1SequenceHolder)this.getNextTaggedGetChild(0, 2);
        if (partialHashtreeSequence == null) {
            return null;
        }
        PartialHashtree[] partialHashtree = new PartialHashtree[partialHashtreeSequence.size()];
        for (int i = 0; i < partialHashtree.length; ++i) {
            partialHashtree[i] = (PartialHashtree)PartialHashtree.FACTORY.create(partialHashtreeSequence.getChild(i));
        }
        return partialHashtree;
    }

    public CMS getTimeStamp() {
        ASN1ValueHolder value = this.getValueHolder().getNextNotTagged(0);
        return (CMS)CMS.FACTORY.create(value);
    }

    @Override
    protected void initializeAfterCreate() {
        super.initializeAfterCreate();
        this.taggingModeExplicit = this.testTaggingModeExplicit();
    }

    protected boolean isDigestAlgorithm(ASN1ValueHolder value) {
        ASN1ValueHolder algId;
        return value.isSequence() && (algId = value.getChild(0)).isScalar() && algId.getValue() instanceof ASN1ObjectIdentifier;
    }

    protected boolean testTaggingModeExplicit() {
        ASN1TaggedHolder to = this.getValueHolder().getNextTagged(0, 0);
        if (to == null) {
            return false;
        }
        ((ASN1ValueHolder)to).setExplicit(false);
        ASN1ValueHolder value = ((ASN1ValueHolder)to).getChild();
        if (this.isDigestAlgorithm(value)) {
            return false;
        }
        ((ASN1ValueHolder)to).setChild(null);
        return true;
    }

    public static class Factory
    extends ASN1Based.Factory<ArchiveTimeStamp> {
    }
}

