/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.common;

import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;

public class RSASSAPSSParams
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public AlgorithmIdentifier getHashAlgorithm() {
        if (!this.hasHashAlgorithm()) {
            return AlgorithmIdentifier.create("1.3.14.3.2.26");
        }
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(0, 0, true);
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(value);
    }

    public AlgorithmIdentifier getMaskGenAlgorithm() {
        if (!this.hasMaskGenAlgorithm()) {
            AlgorithmIdentifier algorithm = AlgorithmIdentifier.create("1.2.840.113549.1.1.8");
            algorithm.setParameters(AlgorithmIdentifier.create("1.3.14.3.2.26"));
            return algorithm;
        }
        ASN1ValueHolder value = this.getValueHolder().getNextTaggedGetChild(0, 1, true);
        return (AlgorithmIdentifier)AlgorithmIdentifier.FACTORY.create(value);
    }

    public int getSaltLength() {
        if (!this.hasSaltLength()) {
            return 20;
        }
        return this.getValueHolder().getNextTaggedGetChild(0, 2, true).toDERInteger().getValue().intValue();
    }

    public int getTrailerField() {
        if (!this.hasTrailerField()) {
            return 1;
        }
        return this.getValueHolder().getNextTaggedGetChild(0, 3, true).toDERInteger().getValue().intValue();
    }

    public boolean hasHashAlgorithm() {
        return this.getValueHolder().getNextTagged(0, 0) != null;
    }

    public boolean hasMaskGenAlgorithm() {
        return this.getValueHolder().getNextTagged(0, 1) != null;
    }

    public boolean hasSaltLength() {
        return this.getValueHolder().getNextTagged(0, 2) != null;
    }

    public boolean hasTrailerField() {
        return this.getValueHolder().getNextTagged(0, 3) != null;
    }

    public void setHashAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        ASN1TaggedHolder value = new ASN1TaggedHolder(true, 0, algorithmIdentifier);
        int index = 0;
        if (this.hasHashAlgorithm()) {
            this.getValueHolder().setChild(index, value);
        } else {
            this.getValueHolder().insertChild(index, value);
        }
    }

    public void setMaskGenAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        ASN1TaggedHolder value = new ASN1TaggedHolder(true, 1, algorithmIdentifier);
        int index = 0;
        if (this.hasHashAlgorithm()) {
            ++index;
        }
        if (this.hasMaskGenAlgorithm()) {
            this.getValueHolder().setChild(index, value);
        } else {
            this.getValueHolder().insertChild(index, value);
        }
    }

    public void setSaltLength(int length) {
        ASN1TaggedHolder value = new ASN1TaggedHolder(true, 2, (ASN1Encodable)new ASN1Integer((long)length));
        int index = 0;
        if (this.hasHashAlgorithm()) {
            ++index;
        }
        if (this.hasMaskGenAlgorithm()) {
            ++index;
        }
        if (this.hasSaltLength()) {
            this.getValueHolder().setChild(index, value);
        } else {
            this.getValueHolder().insertChild(index, value);
        }
    }

    public void setTrailerField(int field) {
        ASN1TaggedHolder value = new ASN1TaggedHolder(true, 3, (ASN1Encodable)new ASN1Integer((long)field));
        int index = 0;
        if (this.hasHashAlgorithm()) {
            ++index;
        }
        if (this.hasMaskGenAlgorithm()) {
            ++index;
        }
        if (this.hasSaltLength()) {
            ++index;
        }
        if (this.hasTrailerField()) {
            this.getValueHolder().setChild(index, value);
        } else {
            this.getValueHolder().insertChild(index, value);
        }
    }

    public static class Factory
    extends ASN1Based.Factory<RSASSAPSSParams> {
    }
}

