/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.policy;

import de.intarsys.asn1.cms.policy.DisplayText;
import de.intarsys.asn1.cms.policy.NoticeReference;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import org.bouncycastle.asn1.ASN1Sequence;

public class SPUserNotice
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public boolean hasNoticeRef() {
        return this.getValueHolder().getNextTyped(0, ASN1Sequence.class) != null;
    }

    public NoticeReference getNoticeRef() {
        if (!this.hasNoticeRef()) {
            return null;
        }
        ASN1ValueHolder value = this.getValueHolder().getNextTyped(0, ASN1Sequence.class);
        return (NoticeReference)NoticeReference.FACTORY.create(value);
    }

    public void setNoticeRef(NoticeReference noticeRef) {
        if (this.hasNoticeRef()) {
            this.getValueHolder().setChild(0, noticeRef);
        } else {
            this.getValueHolder().insertChild(0, noticeRef);
        }
    }

    public boolean hasExplictText() {
        int minSize = 1;
        if (this.hasNoticeRef()) {
            ++minSize;
        }
        return this.size() >= minSize;
    }

    public DisplayText getExplictText() {
        if (!this.hasExplictText()) {
            return null;
        }
        int index = 0;
        if (this.hasNoticeRef()) {
            ++index;
        }
        ASN1ValueHolder value = this.getValueHolder().getChild(index);
        return (DisplayText)DisplayText.FACTORY.create(value);
    }

    public void setExplictText(DisplayText explicitText) {
        int index = 0;
        if (this.hasNoticeRef()) {
            ++index;
        }
        this.getValueHolder().setChild(index, explicitText);
    }

    public static class Factory
    extends ASN1Based.Factory<SPUserNotice> {
    }
}

