/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.policy;

import de.intarsys.asn1.cms.policy.DisplayText;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1SequenceHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;

public class NoticeReference
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public DisplayText getOrganization() {
        return (DisplayText)DisplayText.FACTORY.create(this.getValueHolder().getChild(0));
    }

    public void setOrganization(DisplayText organization) {
        this.getValueHolder().setChild(0, organization);
    }

    public int[] getNoticeNumbers() {
        ASN1ValueHolder asn1NoticeNumbers = this.getValueHolder().getChild(1);
        int[] noticeNumbers = new int[asn1NoticeNumbers.size()];
        for (int i = 0; i < noticeNumbers.length; ++i) {
            noticeNumbers[i] = asn1NoticeNumbers.getChild(i).toDERInteger().getValue().intValue();
        }
        return noticeNumbers;
    }

    public void addNoticeNumber(long noticeNumber) {
        ASN1ValueHolder asn1Values = null;
        if (this.size() < 2) {
            asn1Values = new ASN1SequenceHolder();
            this.getValueHolder().setChild(1, asn1Values);
        } else {
            asn1Values = this.getValueHolder().getChild(1);
        }
        asn1Values.addChild((ASN1Encodable)new ASN1Integer(noticeNumber));
    }

    public static class Factory
    extends ASN1Based.Factory<NoticeReference> {
    }
}

