/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.exception.TunnelingException;
import java.text.ParseException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.x509.Time;

public class AttributeSigningTime
extends Attribute {
    public static final String ID = "1.2.840.113549.1.9.5";
    public static final Factory FACTORY = new Factory();

    public Date getTime() {
        ASN1ValueHolder obj = this.getAttrValue(0);
        if (obj == null) {
            return null;
        }
        if (this.isGeneralizedTime()) {
            ASN1GeneralizedTime derGeneralizedTime = ASN1GeneralizedTime.getInstance((Object)obj.toASN1Primitive());
            try {
                return derGeneralizedTime.getDate();
            }
            catch (ParseException e) {
                throw new TunnelingException((Throwable)e);
            }
        }
        ASN1UTCTime derUTCTime = ASN1UTCTime.getInstance((Object)obj.toASN1Primitive());
        if (derUTCTime == null) {
            return null;
        }
        Time time = Time.getInstance((Object)derUTCTime);
        if (time == null) {
            return null;
        }
        return time.getDate();
    }

    @Override
    protected void initializeAfterCreateNew() {
        super.initializeAfterCreateNew();
        this.setAttrType(ID);
    }

    public boolean isGeneralizedTime() {
        ASN1ValueHolder obj = this.getAttrValue(0);
        return ASN1Tools.isInstanceOf(obj, ASN1GeneralizedTime.class);
    }

    public boolean isUTCTime() {
        ASN1ValueHolder obj = this.getAttrValue(0);
        return !ASN1Tools.isInstanceOf(obj, ASN1GeneralizedTime.class);
    }

    public void setTime(ASN1GeneralizedTime time) {
        this.setAttrValue(0, (ASN1Encodable)time);
    }

    public void setTime(ASN1UTCTime time) {
        this.setAttrValue(0, (ASN1Encodable)time);
    }

    public static class Factory
    extends Attribute.Factory<AttributeSigningTime> {
        @Override
        public String getAttributeType() {
            return AttributeSigningTime.ID;
        }
    }
}

