/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1ValueHolder;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class AttributeMessageDigest
extends Attribute {
    public static final String ID = PKCSObjectIdentifiers.pkcs_9 + ".4";
    public static final Factory FACTORY = new Factory();

    public static AttributeMessageDigest create(byte[] digest) {
        AttributeMessageDigest result = (AttributeMessageDigest)FACTORY.createNew();
        result.setMessageDigest(digest);
        return result;
    }

    public byte[] getMessageDigest() {
        ASN1ValueHolder digest = this.getAttrValue(0);
        if (digest != null) {
            return digest.toDEROctetString().getOctets();
        }
        return null;
    }

    @Override
    protected void initializeAfterCreateNew() {
        super.initializeAfterCreateNew();
        this.setAttrType(ID);
    }

    public void setMessageDigest(byte[] digest) {
        this.setAttrValue(0, (ASN1Encodable)new DEROctetString(digest));
    }

    public static class Factory
    extends Attribute.Factory<AttributeMessageDigest> {
        @Override
        public String getAttributeType() {
            return ID;
        }
    }
}

