/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.OtherRevocationInfoFormat;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.crl.CertificateList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;

public class RevocationInfoChoices
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public void add(CertificateList certificateList) {
        this.getValueHolder().addChild(certificateList);
    }

    public void add(OtherRevocationInfoFormat otherRevocationInfoFormat) {
        this.getValueHolder().addChild(new ASN1TaggedHolder(false, 1, otherRevocationInfoFormat));
    }

    public RevocationInfoChoices copy() throws IOException {
        return (RevocationInfoChoices)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public List<CertificateList> getCertificateLists() {
        ArrayList<CertificateList> result = new ArrayList<CertificateList>();
        for (int i = 0; i < this.getValueHolder().size(); ++i) {
            ASN1ValueHolder child = this.getValueHolder().getChild(i);
            if (child.isTagged()) continue;
            result.add((CertificateList)CertificateList.FACTORY.create(child));
        }
        return result;
    }

    public List<OtherRevocationInfoFormat> getOtherRevocationInfo() {
        ArrayList<OtherRevocationInfoFormat> result = new ArrayList<OtherRevocationInfoFormat>();
        for (int i = 0; i < this.getValueHolder().size(); ++i) {
            ASN1TaggedHolder tagged;
            ASN1ValueHolder child = this.getValueHolder().getChild(i);
            if (!child.isTagged() || (tagged = (ASN1TaggedHolder)child).getTagNo() != 1) continue;
            tagged.setExplicit(false);
            result.add((OtherRevocationInfoFormat)OtherRevocationInfoFormat.FACTORY.create(tagged.getChild()));
        }
        return result;
    }

    public boolean isTypeOtherPresent() {
        return this.getValueHolder().getNextTagged(0, 1) != null;
    }

    public static class Factory
    extends ASN1Based.Factory<RevocationInfoChoices> {
    }
}

