/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.IssuerAndSerialNumber;
import de.intarsys.asn1.common.SubjectKeyIdentifier;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import org.bouncycastle.asn1.ASN1Encodable;

public class RecipientIdentifier
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        if (!this.isIssuerAndSerialNumber()) {
            return null;
        }
        return (IssuerAndSerialNumber)IssuerAndSerialNumber.FACTORY.create((ASN1Encodable)this.toASN1Primitive());
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        if (!this.isSubjectKeyIdentifier()) {
            return null;
        }
        return (SubjectKeyIdentifier)SubjectKeyIdentifier.FACTORY.create(this.getValueHolder().getChild());
    }

    public boolean isIssuerAndSerialNumber() {
        return !this.getValueHolder().isTagged();
    }

    public boolean isSubjectKeyIdentifier() {
        if (!this.getValueHolder().isTagged()) {
            return false;
        }
        return ((ASN1TaggedHolder)this.getValueHolder()).getTagNo() == 0;
    }

    public void setIssuerAndSerialNumber(IssuerAndSerialNumber issuerAndSerial) {
        this.setValueHolder(issuerAndSerial.getValueHolder());
    }

    public void setSubjectKeyIdentifier(SubjectKeyIdentifier subjectKeyIdentifier) {
        this.setValueHolder(new ASN1TaggedHolder(true, 0, subjectKeyIdentifier));
    }

    public static class Factory
    extends ASN1Based.Factory<RecipientIdentifier> {
    }
}

