/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.CMSContent;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;

public class Data
extends CMSContent {
    public static final Factory FACTORY = new Factory();

    public Data copy() throws IOException {
        return (Data)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.getContent();
    }

    public byte[] getContent() {
        ASN1Primitive content = this.toASN1Primitive();
        if (content instanceof ASN1OctetString) {
            return ((ASN1OctetString)content).getOctets();
        }
        try {
            return ASN1Tools.toByteArray(new ASN1Encodable[]{content});
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    public void setContent(ASN1Primitive content) {
        this.getValueHolder().setValue(content);
    }

    public void setContent(byte[] content) {
        this.setContent((ASN1Primitive)new DEROctetString(content));
    }

    public static class Factory
    extends CMSContent.Factory<Data> {
        @Override
        protected ASN1ValueHolder basicCreateValueHolder() {
            return ASN1ValueHolder.create((ASN1Encodable)new DEROctetString(new byte[0]));
        }

        @Override
        public boolean isFactoryFor(String oid) {
            if (oid.equals("1.2.840.113549.1.7.1")) {
                return true;
            }
            return super.isFactoryFor(oid);
        }
    }
}

