/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.ContentType;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.string.PrettyPrinter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;

public abstract class ContentInfo
extends ASN1Based {
    public ASN1Primitive getContent() {
        ASN1ValueHolder vhContent = this.getValueHolder().getChild(1);
        vhContent.setExplicit(true);
        return vhContent.getChild().toASN1Primitive();
    }

    public ContentType getContentType() {
        return (ContentType)ContentType.FACTORY.create(this.getValueHolder().getChild(0));
    }

    public String getContentTypeId() {
        return this.getValueHolder().getChild(0).toDERObjectIdentifier().getId();
    }

    protected void setContent(ASN1Encodable object) {
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 0, object);
        this.getValueHolder().setChild(1, tagged);
    }

    public void setContentType(ContentType contentType) {
        this.getValueHolder().setChild(0, contentType);
    }

    @Override
    public void toString(PrettyPrinter printer) {
        printer.appendMember("contentType", (Object)this.getValueHolder().getChild(0), null);
        if (this.getValueHolder().size() > 1) {
            printer.appendMember("content", (Object)this.getValueHolder().getChild(1), null);
        }
    }

    public static class Factory<T extends ContentInfo>
    extends ASN1Based.Factory<T> {
    }
}

