/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.afm;

import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.cwt.font.afm.AFMChar;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.FastByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class AFMParser {
    protected static final byte[] characterClass;
    protected static final byte CHARCLASS_ANY = 0;
    protected static final byte CHARCLASS_DELIMITER = 1;
    protected static final byte CHARCLASS_DIGIT = 4;
    protected static final byte CHARCLASS_NUMBERSPECIAL = 5;
    protected static final byte CHARCLASS_TOKEN = 3;
    protected static final byte CHARCLASS_WHITESPACE = 2;
    private static final byte[] TOKEN_Comment;
    private static final byte[] TOKEN_EndCharMetrics;
    private static final byte[] TOKEN_EndFlag;
    private static final byte[] TOKEN_EndFontMetrics;
    private static final byte[] TOKEN_StartCharMetrics;
    private static final byte[] TOKEN_StartFlag;
    private static final byte[] TOKEN_StartFontMetrics;
    public static char CHAR_BS;
    public static char CHAR_CR;
    public static char CHAR_FF;
    public static char CHAR_HT;
    public static char CHAR_LF;
    private AFM afm;
    private FastByteArrayOutputStream localStream = new FastByteArrayOutputStream();

    public static final boolean isEOL(int i) {
        return i == CHAR_CR || i == CHAR_LF || i == 12;
    }

    public static final boolean isWhitespace(int i) {
        return characterClass[i] == 2;
    }

    public AFMParser(AFM afm) {
        this.afm = afm;
    }

    public AFM parse(IRandomAccess random) throws IOException {
        this.read(random);
        return this.afm;
    }

    protected void read(IRandomAccess random) throws IOException {
        byte[] token = this.readToken(random);
        if (!Arrays.equals(token, TOKEN_StartFontMetrics)) {
            throw new IOException("afm stream does not start with " + new String(TOKEN_StartFontMetrics));
        }
        this.readToken(random);
        token = this.readFontMetrics(random);
        if (token == null || !Arrays.equals(token, TOKEN_EndFontMetrics)) {
            throw new IOException("afm stream does not end with " + new String(TOKEN_EndFontMetrics));
        }
    }

    protected byte[] readBlock(IRandomAccess random) throws IOException {
        byte[] line = this.readLine(random);
        while (!ByteArrayTools.startsWith((byte[])line, (byte[])TOKEN_EndFlag)) {
            if (!ByteArrayTools.startsWith((byte[])line, (byte[])TOKEN_Comment) && ByteArrayTools.startsWith((byte[])line, (byte[])TOKEN_StartFlag)) {
                line = this.readBlock(random);
            }
            line = this.readLine(random);
        }
        return line;
    }

    protected byte[] readCharMetrics(IRandomAccess random) throws IOException {
        this.readToken(random);
        byte[] line = this.readLine(random);
        while (!ByteArrayTools.startsWith((byte[])line, (byte[])TOKEN_EndCharMetrics)) {
            this.afm.addChar(AFMChar.create(new String(line)));
            line = this.readLine(random);
        }
        return line;
    }

    protected byte[] readFontMetrics(IRandomAccess random) throws IOException {
        byte[] token = this.readToken(random);
        while (token != null && !Arrays.equals(token, TOKEN_EndFontMetrics)) {
            if (!Arrays.equals(token, TOKEN_Comment)) {
                if (Arrays.equals(token, TOKEN_StartCharMetrics)) {
                    token = this.readCharMetrics(random);
                } else if (ByteArrayTools.startsWith((byte[])token, (byte[])TOKEN_StartFlag)) {
                    token = this.readBlock(random);
                } else {
                    String value = new String(this.readLine(random));
                    this.afm.setAttribute(new String(token), value);
                }
            }
            token = this.readToken(random);
        }
        return token;
    }

    public byte[] readLine(IRandomAccess input) throws IOException {
        int next;
        do {
            if ((next = input.read()) != -1) continue;
            return null;
        } while (next == 32 || AFMParser.isWhitespace(next));
        return this.readLineElement(input, next);
    }

    protected byte[] readLineElement(IRandomAccess input, int next) throws IOException {
        this.localStream.reset();
        this.localStream.write(next);
        while ((next = input.read()) != -1 && !AFMParser.isEOL(next)) {
            this.localStream.write(next);
        }
        return this.localStream.toByteArray();
    }

    public void readSpaces(IRandomAccess input) throws IOException {
        int next = 0;
        while ((next = input.read()) != -1) {
            if (next == 32 || AFMParser.isWhitespace(next)) continue;
            input.seekBy(-1L);
            break;
        }
    }

    public byte[] readToken(IRandomAccess input) throws IOException {
        int next;
        do {
            if ((next = input.read()) != -1) continue;
            return null;
        } while (next == 32 || AFMParser.isWhitespace(next));
        return this.readTokenElement(input, next);
    }

    protected byte[] readTokenElement(IRandomAccess input, int next) throws IOException {
        this.localStream.reset();
        this.localStream.write(next);
        while ((next = input.read()) != -1 && next != 32 && !AFMParser.isWhitespace(next)) {
            this.localStream.write(next);
        }
        return this.localStream.toByteArray();
    }

    static {
        int i;
        characterClass = new byte[256];
        TOKEN_Comment = "Comment".getBytes();
        TOKEN_EndCharMetrics = "EndCharMetrics".getBytes();
        TOKEN_EndFlag = "End".getBytes();
        TOKEN_EndFontMetrics = "EndFontMetrics".getBytes();
        TOKEN_StartCharMetrics = "StartCharMetrics".getBytes();
        TOKEN_StartFlag = "Start".getBytes();
        TOKEN_StartFontMetrics = "StartFontMetrics".getBytes();
        CHAR_BS = (char)8;
        CHAR_CR = (char)13;
        CHAR_FF = (char)12;
        CHAR_HT = (char)9;
        CHAR_LF = (char)10;
        for (i = 0; i < 256; ++i) {
            AFMParser.characterClass[i] = 0;
        }
        AFMParser.characterClass[40] = 1;
        AFMParser.characterClass[41] = 1;
        AFMParser.characterClass[60] = 1;
        AFMParser.characterClass[62] = 1;
        AFMParser.characterClass[91] = 1;
        AFMParser.characterClass[93] = 1;
        AFMParser.characterClass[123] = 1;
        AFMParser.characterClass[125] = 1;
        AFMParser.characterClass[47] = 1;
        AFMParser.characterClass[37] = 1;
        AFMParser.characterClass[32] = 2;
        AFMParser.characterClass[9] = 2;
        AFMParser.characterClass[13] = 2;
        AFMParser.characterClass[10] = 2;
        AFMParser.characterClass[12] = 2;
        AFMParser.characterClass[0] = 2;
        AFMParser.characterClass[48] = 4;
        AFMParser.characterClass[49] = 4;
        AFMParser.characterClass[50] = 4;
        AFMParser.characterClass[51] = 4;
        AFMParser.characterClass[52] = 4;
        AFMParser.characterClass[53] = 4;
        AFMParser.characterClass[54] = 4;
        AFMParser.characterClass[55] = 4;
        AFMParser.characterClass[56] = 4;
        AFMParser.characterClass[57] = 4;
        AFMParser.characterClass[46] = 5;
        AFMParser.characterClass[45] = 5;
        AFMParser.characterClass[43] = 5;
        for (i = 97; i <= 122; ++i) {
            AFMParser.characterClass[i] = 3;
        }
        for (i = 65; i <= 90; ++i) {
            AFMParser.characterClass[i] = 3;
        }
    }
}

