/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.conversation.driver;

import de.intarsys.tools.activity.RequestHttpInteraction;
import de.intarsys.tools.activity.RequestPassword;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.TaskCallbackAdapter;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.driver.CommonConversationDriver;
import de.intarsys.tools.conversation.driver.PACKAGE;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.conversation.impl.RequestInputStage;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import de.intarsys.tools.preferences.IPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractiveConversationDriver
extends CommonConversationDriver {
    public static final String PREF_USESYSTEMBROWSER = "useSystemBrowser";
    private static final Logger Log = LoggerFactory.getLogger(InteractiveConversationDriver.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private IPreferences preferences;

    public IPreferences getPreferences() {
        return this.preferences;
    }

    protected void handleRequestPin(IConversation<?> conversation, RequestInputStage inputStage) {
        RequestPassword activity = new RequestPassword(null);
        String message = inputStage.getMessage();
        if (message == null) {
            activity.setMessage(Msg.getMessage("InteractiveConversationDriver.RequestInputStage.pin.defaultMessage", new Object[0]));
        } else {
            activity.setMessage(MessageTools.createMessage((String)"", (String)message, (Object[])new Object[0]));
        }
        String title = inputStage.getTitle();
        if (title == null) {
            activity.setTitle(Msg.getMessage("InteractiveConversationDriver.RequestInputStage.pin.defaultTitle", new Object[0]));
        } else {
            activity.setTitle(MessageTools.createMessage((String)"", (String)title, (Object[])new Object[0]));
        }
        Log.info("{} request PIN '{}'", conversation, (Object)activity.getMessage().getString());
        activity.enter();
        try {
            activity.get();
        }
        catch (Exception e) {
            if (ExceptionTools.isCancellation((Throwable)e)) {
                this.localCancel(conversation);
                return;
            }
            this.localError(conversation, e);
        }
        inputStage.acknowledge(null);
    }

    @Override
    protected void handleRedirect(final IConversation<?> conversation, HttpRedirectStage redirectStage) {
        RequestHttpInteraction activity = new RequestHttpInteraction(null, redirectStage.getUrl(), "http://embedded.intarsys.de/callback(?:.*?)");
        activity.setOutOfBand(redirectStage.isOutOfBand());
        if (this.getPreferences() != null) {
            activity.setUseSystemBrowser(this.preferences.getBoolean(PREF_USESYSTEMBROWSER));
        }
        if (redirectStage.isOutOfBand()) {
            activity.addTaskCallback((ITaskCallback)new TaskCallbackAdapter<String>(){

                protected void onFailedCancellation(TaskFailed exception) {
                    InteractiveConversationDriver.this.localCancel(conversation);
                }

                protected void onFailedException(TaskFailed exception) {
                    InteractiveConversationDriver.this.localError(conversation, (Exception)exception);
                }
            });
        }
        Log.info("{} open browser", conversation);
        activity.enter();
        if (!redirectStage.isOutOfBand()) {
            try {
                activity.get();
            }
            catch (Exception e) {
                if (ExceptionTools.isCancellation((Throwable)e)) {
                    this.localCancel(conversation);
                    return;
                }
                this.localError(conversation, e);
            }
        }
        redirectStage.acknowledge(null);
    }

    @Override
    protected void handleRequestInput(IConversation<?> conversation, RequestInputStage inputStage) {
        if ("pin".equals(inputStage.getType())) {
            this.handleRequestPin(conversation, inputStage);
            return;
        }
        String msg = "request input type " + inputStage.getType() + " not supported";
        UnsupportedOperationException ex = new UnsupportedOperationException(msg);
        this.localError(conversation, ex);
    }

    public void setPreferences(IPreferences preferences) {
        this.preferences = preferences;
    }
}

