/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.conversation.driver;

import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.driver.IConversationDriver;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.conversation.impl.IdleStage;
import de.intarsys.tools.conversation.impl.ProcessingStage;
import de.intarsys.tools.conversation.impl.RequestInputStage;
import de.intarsys.tools.exception.ExceptionTools;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonConversationDriver
implements IConversationDriver {
    private static final Logger Log = LoggerFactory.getLogger(CommonConversationDriver.class);

    protected void errorSchemeNotSupported(IReplyStage replyStage) {
        throw new UnsupportedOperationException("scheme '" + replyStage.getScheme() + "' not supported");
    }

    public final <T> T get(IConversation<T> conversation) throws InterruptedException, ExecutionException {
        this.resetState();
        IReplyStage replyStage = conversation.getReplyStage();
        while (!replyStage.isFinal()) {
            this.handle(conversation, replyStage);
            replyStage = conversation.getReplyStage();
        }
        return conversation.get();
    }

    protected void handle(IConversation<?> conversation, IReplyStage replyStage) {
        try {
            if (replyStage instanceof HttpRedirectStage) {
                HttpRedirectStage redirectStage = (HttpRedirectStage)replyStage;
                this.handleRedirect(conversation, redirectStage);
            } else if (replyStage instanceof IdleStage) {
                IdleStage idleStage = (IdleStage)replyStage;
                this.handleIdle(conversation, idleStage);
            } else if (replyStage instanceof ProcessingStage) {
                ProcessingStage processingStage = (ProcessingStage)replyStage;
                this.handleProcessing(conversation, processingStage);
            } else if (replyStage instanceof RequestInputStage) {
                RequestInputStage inputStage = (RequestInputStage)replyStage;
                this.handleRequestInput(conversation, inputStage);
            } else {
                this.handleUnknown(conversation, replyStage);
            }
        }
        catch (RuntimeException e) {
            this.localError(conversation, e);
        }
    }

    protected void handleIdle(IConversation<?> conversation, IdleStage idleStage) {
        ThreadTools.sleep((long)500L);
        idleStage.acknowledge(null);
    }

    protected void handleProcessing(IConversation<?> conversation, ProcessingStage processingStage) {
        int pollDelay = processingStage.getPollDelay();
        if (pollDelay <= 0) {
            pollDelay = 500;
        }
        ThreadTools.sleep((long)pollDelay);
        processingStage.acknowledge(null);
    }

    protected void handleRedirect(IConversation<?> conversation, HttpRedirectStage redirectStage) {
        this.errorSchemeNotSupported(redirectStage);
    }

    protected void handleRequestInput(IConversation<?> conversation, RequestInputStage inputStage) {
        this.errorSchemeNotSupported(inputStage);
    }

    protected void handleUnknown(IConversation<?> conversation, IReplyStage replyStage) {
        this.errorSchemeNotSupported(replyStage);
    }

    protected void localCancel(IConversation<?> conversation) {
        Log.info("{} local cancel", conversation);
        conversation.cancel(true);
    }

    protected void localError(IConversation<?> conversation, Exception e) {
        Log.info("{} local error", conversation);
        conversation.completeExceptionally(ExceptionTools.unwrap((Throwable)e));
    }

    public void resetState() {
    }
}

