/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.jca.device;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.jca.device.DeviceSignatureSpiRSA;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.digest.NullDigester;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;

public abstract class DeviceSignatureSpiRSAPSS
extends DeviceSignatureSpiRSA {
    protected DeviceSignatureSpiRSAPSS(IDigester digester) throws GeneralSecurityException {
        super(digester);
    }

    @Override
    protected IDigester createDefaultDigester() throws NoSuchAlgorithmException {
        return DigestTools.createDigester((String)"SHA1");
    }

    @Override
    protected IArgs createSignerArgs() {
        IArgs args = super.createSignerArgs();
        ArgTools.putPath((IArgs)args, (String)"rsaSignatureEncoding", (Object)"RSASSA-PSS");
        return args;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            return;
        }
        if (params instanceof PSSParameterSpec) {
            DigestAlgorithm initialHashAlgorithm;
            PSSParameterSpec pssParams = (PSSParameterSpec)params;
            DigestAlgorithm newHashAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)pssParams.getDigestAlgorithm());
            if (this.getInitialDigester() != null && (initialHashAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)this.getInitialDigester().getAlgorithmName())) != newHashAlgorithm) {
                throw new InvalidAlgorithmParameterException("invalid hash algorithm: " + pssParams.getDigestAlgorithm());
            }
            try {
                this.setDigester(DigestTools.createDigester((String)newHashAlgorithm.getCanonicalName()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidAlgorithmParameterException("invalid hash algorithm: " + pssParams.getDigestAlgorithm());
            }
        } else {
            throw new InvalidAlgorithmParameterException("Only PSSParameterSpec supported");
        }
    }

    public static class SHA512
    extends DeviceSignatureSpiRSAPSS {
        public SHA512() throws GeneralSecurityException {
            super(DigestTools.createDigester((String)"SHA512"));
        }
    }

    public static class SHA256
    extends DeviceSignatureSpiRSAPSS {
        public SHA256() throws GeneralSecurityException {
            super(DigestTools.createDigester((String)"SHA256"));
        }
    }

    public static class SHA1
    extends DeviceSignatureSpiRSAPSS {
        public SHA1() throws GeneralSecurityException {
            super(DigestTools.createDigester((String)"SHA1"));
        }
    }

    public static class None
    extends DeviceSignatureSpiRSAPSS {
        public None() throws GeneralSecurityException {
            super((IDigester)new NullDigester());
        }
    }

    public static class Default
    extends DeviceSignatureSpiRSAPSS {
        public Default() throws GeneralSecurityException {
            super(null);
        }
    }
}

