/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.processor;

import de.intarsys.processor.decorate.PreprocessorTools;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.processor.ISignerFactory;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.CommonInstantiatingFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Arrays;
import java.util.Collection;

public abstract class CommonSignerFactory<T extends ISigner>
extends CommonInstantiatingFactory<T>
implements ISignerFactory<T> {
    public static final Collection<String> DEFAULT_SUPPORTED_HASH_ALGORITHM_NAMES = Arrays.asList("SHA-1", "SHA-256", "SHA-384", "SHA-512", "RIPEMD160", "RIPEMD256");

    protected void basicCreateInstanceInit(T object, IArgs args) throws ObjectCreationException {
        try {
            super.basicCreateInstanceInit(object, args);
            PreprocessorTools.preprocess(object, (IArgs)args);
        }
        catch (Exception e) {
            object.dispose();
            throw (ObjectCreationException)ExceptionTools.createTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    public Class getResultType() {
        return ISigner.class;
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return DEFAULT_SUPPORTED_HASH_ALGORITHM_NAMES;
    }
}

