/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.health;

import de.intarsys.security.device.health.IHealthMonitor;
import de.intarsys.security.device.health.IHealthMonitorTarget;
import de.intarsys.security.device.health.StandardHealthMonitorState;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonHealthMonitor<T extends IHealthMonitorTarget>
implements IHealthMonitor<T> {
    private static final Logger Log = LoggerFactory.getLogger(CommonHealthMonitor.class);
    private T target;

    public static IHealthMonitor from(Object value) throws ObjectCreationException {
        if (value instanceof IHealthMonitor) {
            IHealthMonitor result = (IHealthMonitor)value;
            return result;
        }
        return CommonHealthMonitor.fromArgs(ArgTools.toArgs((Object)value));
    }

    public static IHealthMonitor fromArgs(IArgs args) throws ObjectCreationException {
        if (args == null) {
            return null;
        }
        InstanceSpec spec = InstanceSpec.createFromArgs(IHealthMonitor.class, (Object)args);
        if (spec == null) {
            return null;
        }
        return (IHealthMonitor)spec.createInstance();
    }

    protected abstract void basicStart();

    protected abstract void basicStop();

    protected void fail(Exception ex) {
        this.getTarget().setHealthMonitorState(new StandardHealthMonitorState((IHealthMonitorTarget)this.target, ex));
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    public void setArgs(IArgs args) {
    }

    protected void setTarget(T target) {
        this.target = target;
    }

    @Override
    public final void start(T target) {
        this.setTarget(target);
        this.basicStart();
    }

    @Override
    public final void stop() {
        this.basicStop();
        this.setTarget(null);
    }

    protected void success() {
        this.getTarget().setHealthMonitorState(new StandardHealthMonitorState((IHealthMonitorTarget)this.target, null));
    }
}

