/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.signature;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigestSupport;
import java.io.IOException;
import java.util.Base64;

public class SignatureItemEvidence
implements IDigestSupport {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String label;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSerialize(using=DigestSerializer.class)
    private IDigest digest;

    public IDigest getDigest() {
        return this.digest;
    }

    public String getLabel() {
        return this.label;
    }

    public void setDigest(IDigest digest) {
        this.digest = digest;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return this.getLabel();
    }

    public static class DigestSerializer
    extends StdSerializer<IDigest> {
        public DigestSerializer() {
            super(IDigest.class);
        }

        public void serialize(IDigest object, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (object == null) {
                provider.defaultSerializeNull(gen);
                return;
            }
            gen.writeStartObject();
            provider.defaultSerializeField("algorithm", (Object)object.getAlgorithmName(), gen);
            provider.defaultSerializeField("bytes", (Object)Base64.getEncoder().encode(object.getBytes()), gen);
            gen.writeEndObject();
        }
    }
}

