/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.signature;

import de.intarsys.security.app.CommonApplicationPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CertificatePeriodValidator;
import de.intarsys.security.certificate.common.CertificateSignatureAlgorithmValidator;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.notice.INoticesSupport;
import de.intarsys.tools.validation.IValidationResult;
import de.intarsys.tools.validation.ValidationResult;

public class CommonSignerPolicy
extends CommonApplicationPolicy<ISigner> {
    private final CertificatePeriodValidator certPeriodValidator = new CertificatePeriodValidator();
    private final CertificateSignatureAlgorithmValidator certSigAlgValidator = new CertificateSignatureAlgorithmValidator();

    public CommonSignerPolicy(CommonDeviceProvider<?> deviceProvider) {
        super(deviceProvider);
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        IElement elValidator = element.element("validator");
        if (elValidator != null) {
            IElement elCertSigAlg;
            IElement elCertPeriod = elValidator.element("certificatePeriod");
            if (elCertPeriod != null) {
                this.certPeriodValidator.configure(elCertPeriod);
            }
            if ((elCertSigAlg = elValidator.element("certificateSignatureAlgorithm")) != null) {
                this.certSigAlgValidator.configure(elCertSigAlg);
            }
        }
    }

    public IValidationResult validate(ISigner target) {
        ValidationResult result = new ValidationResult((Object)target);
        IX509PublicKeyCertificate[] certs = target.getCertificatePath();
        if (certs != null && certs.length > 0) {
            IX509PublicKeyCertificate cert = certs[0];
            result.addNotices((INoticesSupport)this.certSigAlgValidator.validate(cert));
            result.addNotices((INoticesSupport)this.certPeriodValidator.validate((Object)cert));
        }
        return result;
    }
}

