/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.common;

import de.intarsys.security.app.AuthenticationException;
import de.intarsys.security.app.AuthenticationExceptionEvent;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.common.AbstractSecurityApplication;
import de.intarsys.security.app.common.PACKAGE;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.authenticate.PasswordProvider;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.ReflectiveResolver;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.EnumLicenseState;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.ILicenseStateSupport;
import de.intarsys.tools.license.ILicenseWithdrawal;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tools.notice.INotice;
import de.intarsys.tools.notice.Notice;
import de.intarsys.tools.observation.api.Observation;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.validation.IValidationResult;
import de.intarsys.tools.validation.ValidationTools;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonSecurityApplication
extends AbstractSecurityApplication
implements IStringEvaluator {
    private static final Logger Log = LoggerFactory.getLogger(CommonSecurityApplication.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final AtomicBoolean authenticated = new AtomicBoolean(false);
    private final IStringEvaluator basicResolver = new ReflectiveResolver((Object)this);
    private final IStringEvaluator templateEvaluator = TaggedStringEvaluator.decorate((IStringEvaluator[])new IStringEvaluator[]{ExpressionEvaluator.get((Mode)Mode.UNTRUSTED), this});
    private final Map<String, Object> publishProperties = new HashMap<String, Object>();
    private IPasswordProvider passwordProvider;
    private String authenticationPrompt;
    private long authenticationTime = -1L;
    private Secret authenticationPin;
    private int useCount = 0;
    private int restrictionCount = -1;
    private long restrictionTime = -1L;
    private ILicenseAccount licenseAccount;
    private ILicenseWithdrawal licenseBooking;

    protected CommonSecurityApplication(CommonDevice device) {
        super(device);
    }

    @Override
    public IConversation<Void> authenticate() {
        if (this.isAuthenticated()) {
            return Conversation.completed(null);
        }
        this.publishStart("authenticate");
        this.sendNotification((INotice)new Notice(Msg, "application.authenticationRequired", new Object[]{this.getLabel()}));
        return this.basicAuthenticate().thenAccept(ignore -> {
            this.authenticationTime = System.currentTimeMillis();
            this.useCount = 0;
            this.authenticated.set(true);
            this.publishOk("authenticate");
            this.sendNotification((INotice)new Notice(Msg, "application.authenticationFinished", new Object[]{this.getLabel()}));
        }).exceptionally(e -> {
            this.sendNotification((INotice)new Notice(Msg, 30, false, "application.authenticationFailed", new Object[]{this.getLabel()}));
            this.handleAuthenticationFailed((Throwable)e);
            this.publishFail((Throwable)e, "authenticate");
            throw Conversation.rethrowable((Throwable)e);
        });
    }

    protected IConversation<Void> basicAuthenticate() {
        return Conversation.completed(null);
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
    }

    @Override
    protected void basicDispose() {
        super.basicDispose();
        this.authenticated.set(false);
    }

    @Override
    protected CommonDevice basicGetDevice() {
        return (CommonDevice)super.basicGetDevice();
    }

    @Override
    protected void basicReset() {
        super.basicReset();
        this.licenseBooking = null;
    }

    private void buildAndPublishObservation(String subcode, String operation, String step) {
        this.publishPropertyPut("app", this);
        this.publishPropertyPut("id", this.getId());
        this.publishPropertyPut("operation", operation);
        this.publishPropertyPut("subcode", subcode);
        Observation.ObservationBuilder builder = Observation.builder().source(this.getPublishSource()).putAll(this.getPublishProperties());
        if (step != null) {
            builder.put("step", (Object)step);
            builder.message(Msg.getMessage(operation + "." + step + "." + subcode, new Object[0]));
        } else {
            builder.message(Msg.getMessage(operation + "." + subcode, new Object[0]));
        }
        builder.build().publish();
    }

    protected boolean checkRestriction() {
        if (this.getRestrictionCount() > 0 && this.getRestrictionCount() <= this.getUseCount()) {
            return false;
        }
        if (this.getRestrictionTime() > 0L) {
            return this.getRestrictionTime() >= this.getUseTime();
        }
        return true;
    }

    @Override
    public void deauthenticate() throws SecurityApplicationException {
        this.authenticated.set(false);
        this.basicDeauthenticate();
    }

    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        return this.basicResolver.evaluate(expression, args);
    }

    public String expand(String template) {
        if (template == null) {
            return null;
        }
        try {
            return (String)this.getTemplateEvaluator().evaluate(template, (IArgs)Args.create());
        }
        catch (EvaluationException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return template;
        }
    }

    protected Secret getAuthenticationPin() {
        return this.authenticationPin;
    }

    @Override
    public String getAuthenticationPrompt() {
        return this.authenticationPrompt;
    }

    protected String getAuthenticationPromptDefault() {
        return "";
    }

    protected IMessage getAuthenticationPromptExpanded() {
        String defaultPrompt = this.getAuthenticationPromptDefault();
        String template = this.getAuthenticationPrompt();
        if (StringTools.isEmpty((String)template)) {
            template = defaultPrompt;
        }
        Args args = Args.create();
        ArgTools.putPath((IArgs)args, (String)"prompt.default", (Object)defaultPrompt);
        String expanded = TemplateEvaluator.evaluateString((Mode)Mode.UNTRUSTED, (String)template, (IArgs)args);
        return LiteralMessage.create((String)expanded);
    }

    public long getAuthenticationTime() {
        return this.authenticationTime;
    }

    protected IMessage getAuthenticationTitle() {
        return Msg.getMessage("CommonSecurityApplication.Authentication.title", new Object[0]);
    }

    public ILicenseAccount getLicenseAccount() {
        return this.licenseAccount;
    }

    public EnumLicenseState getLicenseState() {
        IDevice iDevice = this.getDevice();
        if (iDevice instanceof ILicenseStateSupport) {
            ILicenseStateSupport lss = (ILicenseStateSupport)iDevice;
            return lss.getLicenseState();
        }
        return EnumLicenseState.VALID;
    }

    @Override
    public IPasswordProvider getPasswordProvider() {
        if (this.passwordProvider == null) {
            return PasswordProvider.get();
        }
        return this.passwordProvider;
    }

    protected Map<String, Object> getPublishProperties() {
        return this.publishProperties;
    }

    protected String getPublishSource() {
        return "device." + this.getDevice().getDeviceProvider().getId() + "." + this.getDevice().getId();
    }

    @Override
    public int getRestrictionCount() {
        return this.restrictionCount;
    }

    @Override
    public long getRestrictionTime() {
        return this.restrictionTime;
    }

    public IStringEvaluator getTemplateEvaluator() {
        return this.templateEvaluator;
    }

    @Override
    public int getUseCount() {
        return this.useCount;
    }

    @Override
    public long getUseTime() {
        return System.currentTimeMillis() - this.getAuthenticationTime();
    }

    protected void handleAuthenticationFailed(Throwable e) {
        if (e instanceof AuthenticationException) {
            AuthenticationException ae = (AuthenticationException)e;
            this.setAuthenticationPin(Secret.EMPTY);
            this.triggerEvent(new AuthenticationExceptionEvent(this, ae));
        }
    }

    protected void incUseCount() {
        ++this.useCount;
    }

    public boolean isAuthenticated() {
        return this.authenticated.get();
    }

    @Override
    public boolean isValid() {
        return !this.isDisposed();
    }

    protected void licenseBookingAbort() {
        if (this.licenseBooking != null) {
            this.licenseBooking.abort();
            this.licenseBooking = null;
        }
    }

    protected void licenseBookingCommit() {
        if (this.licenseBooking != null) {
            this.licenseBooking.commit();
            this.licenseBooking = null;
        }
    }

    protected ILicenseWithdrawal licenseReserve() throws LicenseException {
        return this.licenseReserve(1);
    }

    protected ILicenseWithdrawal licenseReserve(int count) {
        this.licenseBooking = null;
        if (this.getLicenseAccount() != null) {
            this.licenseBooking = this.getLicenseAccount().reserve(count);
        }
        return this.licenseBooking;
    }

    protected void licenseWithdraw() throws LicenseException {
        this.licenseWithdraw(1);
    }

    protected void licenseWithdraw(int count) {
        if (this.getLicenseAccount() != null) {
            this.getLicenseAccount().reserve(count).commit();
        }
    }

    protected void publish(String subcode, String operation) {
        this.buildAndPublishObservation(subcode, operation, null);
    }

    public void publish(String subcode, String operation, String step) {
        this.buildAndPublishObservation(subcode, operation, step);
    }

    protected void publishCancel(String operation) {
        this.publish("cancel", operation);
    }

    protected void publishFail(Throwable e, String operation) {
        this.publish("fail", operation);
    }

    protected void publishOk(String operation) {
        this.publish("ok", operation);
    }

    protected void publishPropertyPut(String key, Object value) {
        this.getPublishProperties().put(key, value);
    }

    protected void publishStart(String operation) {
        this.publish("start", operation);
    }

    protected void sendNotification(INotice notice) {
        ((CommonDevice)this.getDevice()).sendNotification(notice);
    }

    protected void sendNotificationFailed(Throwable e) {
        this.sendNotification((INotice)new Notice(Msg, 30, false, "application.failed", new Object[]{this.getLabel(), e}));
    }

    @Override
    public void setAuthenticationPin(Secret authenticationPin) {
        this.authenticationPin = authenticationPin;
    }

    @Override
    public void setAuthenticationPrompt(String authenticationPrompt) {
        this.authenticationPrompt = authenticationPrompt;
    }

    public void setLicenseAccount(ILicenseAccount licenseAccount) {
        if (this.licenseAccount != null) {
            throw new LicenseException("license tampering");
        }
        this.licenseAccount = licenseAccount;
    }

    @Override
    public void setPasswordProvider(IPasswordProvider passwordProvider) {
        this.passwordProvider = passwordProvider;
    }

    @Override
    public void setRestrictionCount(int restrictCount) {
        this.restrictionCount = restrictCount;
    }

    @Override
    public void setRestrictionTime(long restrictionTime) {
        this.restrictionTime = restrictionTime;
    }

    protected void validate() throws SecurityApplicationException {
        IApplicationPolicy<?> policy = this.getDescriptor().getPolicy();
        if (policy == null) {
            return;
        }
        IValidationResult result = policy.validate(this);
        for (INotice notice : result.getNotices()) {
            if (notice.getSeverity() != 30 && notice.getSeverity() != 20) continue;
            this.sendNotification(notice);
        }
        if (!result.getNotices().isEmpty()) {
            String summary = ValidationTools.getSummary((IValidationResult)result, (int)20);
            if (result.hasError()) {
                Log.error(summary);
                throw new SecurityApplicationException(summary);
            }
            if (result.hasWarning()) {
                Log.warn(summary);
            }
        }
    }
}

