/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.tools.kernel;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.string.StringTools;
import java.awt.Color;
import java.util.ArrayList;

public class PDFColorTools {
    public static float[] fixColorValues(float[] values) {
        if (values == null) {
            return null;
        }
        for (int i = 0; i < values.length; ++i) {
            values[i] = Math.max(Math.min(values[i], 1.0f), 0.0f);
        }
        return values;
    }

    public static float[] parse(String colors) {
        if (StringTools.isEmpty((String)colors)) {
            return null;
        }
        String[] split = colors.split(";");
        ArrayList<Float> tmpColors = new ArrayList<Float>();
        try {
            for (String number : split) {
                if (StringTools.isEmpty((String)number)) continue;
                tmpColors.add(Float.valueOf(Float.parseFloat(number.trim())));
            }
        }
        catch (NumberFormatException e) {
            try {
                Color color = (Color)ConverterRegistry.get().convert((Object)colors, Color.class);
                return color.getRGBColorComponents(null);
            }
            catch (ConversionException conversionException) {
                throw new IllegalArgumentException("color number format invalid", e);
            }
        }
        if (tmpColors.size() == 1) {
            return new float[]{((Float)tmpColors.get(0)).floatValue()};
        }
        if (tmpColors.size() == 3) {
            return new float[]{((Float)tmpColors.get(0)).floatValue(), ((Float)tmpColors.get(1)).floatValue(), ((Float)tmpColors.get(2)).floatValue()};
        }
        if (tmpColors.size() == 4) {
            return new float[]{((Float)tmpColors.get(0)).floatValue(), ((Float)tmpColors.get(1)).floatValue(), ((Float)tmpColors.get(2)).floatValue(), ((Float)tmpColors.get(3)).floatValue()};
        }
        throw new IllegalArgumentException("color requires 1, 3 or 4 color components");
    }

    private PDFColorTools() {
    }
}

