/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDFunction;

public class PDStitchingFunction
extends PDFunction {
    private static final COSName DK_Bounds = COSName.constant("Bounds");
    private static final COSName DK_Encode = COSName.constant("Encode");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private static final COSName DK_Functions = COSName.constant("Functions");
    private float[] bounds;
    private float[] encode;
    private PDFunction[] functions;

    protected PDStitchingFunction(COSObject object) {
        super(object);
        int index;
        COSArray cosBounds = object.asDictionary().get(DK_Bounds).asArray();
        this.bounds = new float[cosBounds.size()];
        for (index = 0; index < cosBounds.size(); ++index) {
            this.bounds[index] = ((COSNumber)cosBounds.get(index)).floatValue();
        }
        COSArray cosEncode = object.asDictionary().get(DK_Encode).asArray();
        this.encode = new float[cosEncode.size()];
        for (index = 0; index < cosEncode.size(); ++index) {
            this.encode[index] = ((COSNumber)cosEncode.get(index)).floatValue();
        }
    }

    @Override
    public float[] evaluate(float[] values) {
        int index;
        for (index = 0; index < this.bounds.length; ++index) {
            if (!(values[0] < this.bounds[index])) continue;
            return this.getFunctions()[index].evaluate(values);
        }
        return this.getFunctions()[index].evaluate(values);
    }

    public float[] getBounds() {
        return this.bounds;
    }

    public float[] getEncode() {
        return this.encode;
    }

    public PDFunction[] getFunctions() {
        if (this.functions == null) {
            COSArray cosFunctions = this.cosGetObject().asDictionary().get(DK_Functions).asArray();
            this.functions = new PDFunction[cosFunctions.size()];
            for (int index = 0; index < cosFunctions.size(); ++index) {
                this.functions[index] = (PDFunction)PDFunction.META.createFromCos(cosFunctions.get(index));
            }
        }
        return this.functions;
    }

    @Override
    public int getOutputSize() {
        return this.getRange().size() / 2;
    }

    public static class MetaClass
    extends PDFunction.MetaClass {
        protected MetaClass(Class paramInstanceClass) {
            super(paramInstanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDStitchingFunction(object);
        }
    }
}

