/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import java.util.Iterator;

public class PDInkAnnotation
extends PDMarkupAnnotation {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    public PDInkAnnotation(COSObject object) {
        super(object);
    }

    @Override
    protected COSName cosGetExpectedSubtype() {
        return PDMarkupAnnotation.CN_Subtype_Ink;
    }

    @Override
    public float getMinHeight() {
        float width = this.getBorderStyleWidth();
        return width;
    }

    @Override
    public float getMinWidth() {
        float width = this.getBorderStyleWidth();
        return width;
    }

    @Override
    protected void updateStateRectangle(CDSRectangle oldRectangle, CDSRectangle newRectangle) {
        COSArray traces = this.cosGetField(PDMarkupAnnotation.DK_InkList).asArray();
        if (traces == null) {
            return;
        }
        double oldX = oldRectangle.getLowerLeftX();
        double oldY = oldRectangle.getLowerLeftY();
        double oldWidth = oldRectangle.getWidth();
        double oldHeight = oldRectangle.getHeight();
        double dX = (double)newRectangle.getLowerLeftX() - oldX;
        double dY = (double)newRectangle.getLowerLeftY() - oldY;
        double fX = (double)newRectangle.getWidth() / oldWidth;
        double fY = (double)newRectangle.getHeight() / oldHeight;
        COSArray newTraces = COSArray.create();
        this.cosSetField(PDMarkupAnnotation.DK_InkList, newTraces);
        Iterator<COSObject> itTraces = traces.iterator();
        block0: while (itTraces.hasNext()) {
            COSArray trace = itTraces.next().asArray();
            if (trace == null) continue;
            COSArray newTrace = COSArray.create();
            newTraces.add(newTrace);
            Iterator<COSObject> itTrace = trace.iterator();
            while (itTrace.hasNext()) {
                COSNumber cosX = itTrace.next().asNumber();
                if (!itTrace.hasNext()) continue block0;
                COSNumber cosY = itTrace.next().asNumber();
                if (cosX == null || cosY == null) continue;
                float x = cosX.floatValue();
                float y = cosY.floatValue();
                newTrace.add(COSFixed.create((float)(((double)x - oldX) * fX + oldX + dX)));
                newTrace.add(COSFixed.create((float)(((double)y - oldY) * fY + oldY + dY)));
            }
        }
    }

    public static class MetaClass
    extends PDMarkupAnnotation.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDInkAnnotation(object);
        }
    }
}

