/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorType3;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDSingleByteFont;
import de.intarsys.pdf.pd.IResourcesProvider;
import de.intarsys.pdf.pd.PDResources;

public class PDFontType3
extends PDSingleByteFont
implements IResourcesProvider {
    public static final COSName DK_FontBBox = COSName.constant("FontBBox");
    public static final COSName DK_FontMatrix = COSName.constant("FontMatrix");
    public static final COSName DK_CharProcs = COSName.constant("CharProcs");
    public static final COSName DK_Resources = COSName.constant("Resources");
    public static final COSName DK_ToUnicode = COSName.constant("ToUnicode");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    public PDFontType3(COSObject object) {
        super(object);
    }

    public COSDictionary cosGetCharProcs() {
        return this.cosGetField(DK_CharProcs).asDictionary();
    }

    @Override
    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_Type3;
    }

    public COSDictionary cosSetCharProcs(COSDictionary newDict) {
        return this.cosSetField(DK_CharProcs, newDict).asDictionary();
    }

    @Override
    protected PDFontDescriptor createBuiltinFontDescriptor() {
        return new PDFontDescriptorType3(this);
    }

    public CDSRectangle getFontBB() {
        return CDSRectangle.createFromCOS(this.cosGetField(DK_FontBBox).asArray());
    }

    @Override
    public String getFontFamilyName() {
        return "Helvetica";
    }

    public CDSMatrix getFontMatrix() {
        return CDSMatrix.createFromCOS(this.cosGetField(DK_FontMatrix).asArray());
    }

    @Override
    public String getFontName() {
        return "Helvetica";
    }

    @Override
    public PDFontStyle getFontStyle() {
        return PDFontStyle.REGULAR;
    }

    @Override
    public String getFontType() {
        return "Type3";
    }

    @Override
    public float getGlyphWidthEncoded(int codePoint) {
        float width = super.getGlyphWidthEncoded(codePoint);
        float[] vector = new float[]{width, 0.0f};
        vector = this.getFontMatrix().transform(vector);
        return vector[0] * 1000.0f;
    }

    @Override
    public PDResources getResources() {
        COSDictionary dict = this.cosGetField(DK_Resources).asDictionary();
        return (PDResources)PDResources.META.createFromCos(dict);
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public boolean isSubset() {
        return false;
    }

    public void setFontBB(CDSRectangle fontBB) {
        this.setFieldObject(DK_FontBBox, fontBB);
    }

    public void setFontMatrix(CDSMatrix fontMatrix) {
        this.setFieldObject(DK_FontMatrix, fontMatrix);
    }

    @Override
    public void setResources(PDResources resources) {
        this.cosSetField(DK_Resources, resources.cosGetDict());
    }

    @Override
    public String toString() {
        return this.cosGetSubtype() + "-Font ";
    }

    public static class MetaClass
    extends PDFont.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDFontType3(object);
        }
    }
}

