/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

public class PDFontStyle {
    public static final int COUNT = 4;
    public static final PDFontStyle UNDEFINED = new PDFontStyle("?", -1);
    public static final PDFontStyle REGULAR = new PDFontStyle("Regular", 0);
    public static final PDFontStyle ITALIC = new PDFontStyle("Italic", 1);
    public static final PDFontStyle BOLD = new PDFontStyle("Bold", 2);
    public static final PDFontStyle BOLD_ITALIC = new PDFontStyle("BoldItalic", 3);
    private final String label;
    private final int index;

    public static PDFontStyle getFontStyle(String name) {
        if (name == null) {
            return REGULAR;
        }
        name = name.trim().toLowerCase();
        boolean bold = false;
        boolean italic = false;
        if (name.indexOf("bold") >= 0) {
            bold = true;
        }
        if (name.indexOf("italic") >= 0) {
            italic = true;
        }
        if (name.indexOf("oblique") >= 0) {
            italic = true;
        }
        if (bold) {
            if (italic) {
                return BOLD_ITALIC;
            }
            return BOLD;
        }
        if (italic) {
            return ITALIC;
        }
        return REGULAR;
    }

    private PDFontStyle(String label, int index) {
        this.label = label;
        this.index = index;
    }

    public PDFontStyle getBoldFlavor() {
        if (this == ITALIC) {
            return BOLD_ITALIC;
        }
        return BOLD;
    }

    protected int getIndex() {
        return this.index;
    }

    public PDFontStyle getItalicFlavor() {
        if (this == BOLD) {
            return BOLD_ITALIC;
        }
        return ITALIC;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }
}

