/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.filter.IPrediction;
import de.intarsys.pdf.filter.IPredictionFactory;
import de.intarsys.pdf.filter.NoPrediction;
import de.intarsys.pdf.filter.PNGOptimumPrediction;
import de.intarsys.pdf.filter.Prediction;
import de.intarsys.pdf.filter.TIFFPrediction;
import java.io.IOException;

public class StandardPredictionFactory
implements IPredictionFactory {
    @Override
    public IPrediction createPrediction(COSDictionary options) throws IOException {
        COSInteger value = options.get(Prediction.DK_Predictor).asInteger();
        int predictor = value == null ? 1 : value.intValue();
        if (predictor == 1) {
            return new NoPrediction(options);
        }
        if (predictor == 2) {
            return new TIFFPrediction(options);
        }
        if (predictor >= 10) {
            return new PNGOptimumPrediction(options);
        }
        throw new IOException("unknown predictor: " + predictor);
    }
}

