/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.crypt.AccessPermissionsFull;
import de.intarsys.pdf.crypt.AccessPermissionsR3;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.crypt.SaslPrep;
import de.intarsys.pdf.crypt.StandardSecurityHandler;
import de.intarsys.tools.crypto.CryptoTools;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class StandardSecurityHandlerR6
extends StandardSecurityHandler {
    private static final String ALGORITHM_AES = "AES";
    public static final String DIGEST_ALGORITHM = "SHA-256";
    private static final String[] DIGEST_ALGORITHM_LIST = new String[]{"SHA-256", "SHA-384", "SHA-512"};
    private SecureRandom random;

    @Override
    public boolean authenticateOwner(byte[] owner) throws COSSecurityException {
        if (owner == null) {
            owner = new byte[]{};
        }
        byte[] truncatedPassword = this.truncate(SaslPrep.saslPrepQuery(new String(owner)).getBytes(), 127);
        byte[] oHash = new byte[32];
        byte[] oValidationSalt = new byte[8];
        System.arraycopy(this.getO(), 0, oHash, 0, 32);
        System.arraycopy(this.getO(), 32, oValidationSalt, 0, 8);
        byte[] hash = this.computeHash2A(truncatedPassword, oValidationSalt, this.getU());
        if (Arrays.equals(hash, oHash)) {
            this.setCryptKey(this.createCryptKey(owner));
            this.setActiveAccessPermissions(AccessPermissionsFull.get());
        }
        return Arrays.equals(hash, oHash);
    }

    @Override
    public boolean authenticateUser(byte[] user) throws COSSecurityException {
        if (user == null) {
            user = new byte[]{};
        }
        byte[] truncatedPassword = this.truncate(SaslPrep.saslPrepQuery(new String(user)).getBytes(), 127);
        byte[] uHash = new byte[32];
        byte[] uValidationSalt = new byte[8];
        System.arraycopy(this.getU(), 0, uHash, 0, 32);
        System.arraycopy(this.getU(), 32, uValidationSalt, 0, 8);
        byte[] hash = this.computeHash2A(truncatedPassword, uValidationSalt, null);
        if (Arrays.equals(hash, uHash)) {
            this.setCryptKey(this.createCryptKey(user));
            this.setActiveAccessPermissions(this.createAccessPermissions());
        }
        return Arrays.equals(hash, uHash);
    }

    private byte[] computeHash2A(byte[] password, byte[] salt, byte[] u) throws COSSecurityException {
        byte[] userKey;
        if (u == null) {
            userKey = new byte[]{};
        } else {
            if (u.length < 48) {
                throw new COSSecurityException("Invalid user password length");
            }
            if (u.length > 48) {
                userKey = new byte[48];
                System.arraycopy(u, 0, userKey, 0, 48);
            } else {
                userKey = u;
            }
        }
        byte[] truncatedPassword = this.truncate(password, 127);
        byte[] input = this.concat(truncatedPassword, salt, userKey);
        return this.computeHash2B(input, truncatedPassword, userKey);
    }

    private byte[] computeHash2B(byte[] input, byte[] password, byte[] userKey) throws COSSecurityException {
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            byte[] k = md.digest(input);
            byte[] e = null;
            for (int round = 0; round < 64 || (e[e.length - 1] & 0xFF) > round - 32; ++round) {
                byte[] k1 = userKey != null && userKey.length >= 48 ? new byte[64 * (password.length + k.length + 48)] : new byte[64 * (password.length + k.length)];
                int pos = 0;
                for (int i = 0; i < 64; ++i) {
                    System.arraycopy(password, 0, k1, pos, password.length);
                    System.arraycopy(k, 0, k1, pos += password.length, k.length);
                    pos += k.length;
                    if (userKey == null || userKey.length < 48) continue;
                    System.arraycopy(userKey, 0, k1, pos, 48);
                    pos += 48;
                }
                byte[] kFirst = new byte[16];
                byte[] kSecond = new byte[16];
                System.arraycopy(k, 0, kFirst, 0, 16);
                System.arraycopy(k, 16, kSecond, 0, 16);
                Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                SecretKeySpec keySpec = new SecretKeySpec(kFirst, ALGORITHM_AES);
                IvParameterSpec ivSpec = new IvParameterSpec(kSecond);
                cipher.init(1, (Key)keySpec, ivSpec);
                e = cipher.doFinal(k1);
                byte[] eFirst = new byte[16];
                System.arraycopy(e, 0, eFirst, 0, 16);
                BigInteger bi = new BigInteger(1, eFirst);
                BigInteger remainder = bi.mod(new BigInteger("3"));
                String nextHash = DIGEST_ALGORITHM_LIST[remainder.intValue()];
                md = MessageDigest.getInstance(nextHash);
                k = md.digest(e);
            }
            if (k.length > 32) {
                byte[] kTrunc = new byte[32];
                System.arraycopy(k, 0, kTrunc, 0, 32);
                return kTrunc;
            }
            return k;
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    private byte[] concat(byte[] a, byte[] b) {
        byte[] o = new byte[a.length + b.length];
        System.arraycopy(a, 0, o, 0, a.length);
        System.arraycopy(b, 0, o, a.length, b.length);
        return o;
    }

    private byte[] concat(byte[] a, byte[] b, byte[] c) {
        byte[] o = new byte[a.length + b.length + c.length];
        System.arraycopy(a, 0, o, 0, a.length);
        System.arraycopy(b, 0, o, a.length, b.length);
        System.arraycopy(c, 0, o, a.length + b.length, c.length);
        return o;
    }

    @Override
    protected IAccessPermissions createAccessPermissions() {
        return new AccessPermissionsR3(this.getPermissionFlags());
    }

    @Override
    protected byte[] createCryptKey(byte[] password) throws COSSecurityException {
        try {
            password = password == null ? new byte[]{} : this.truncate(password, 127);
            byte[] oHash = new byte[32];
            byte[] oValidationSalt = new byte[8];
            if (this.getO().length < 40) {
                throw new IOException("Owner password is too short");
            }
            System.arraycopy(this.getO(), 0, oHash, 0, 32);
            System.arraycopy(this.getO(), 32, oValidationSalt, 0, 8);
            byte[] fileEncryptionKey = null;
            byte[] hash = this.computeHash2A(password, oValidationSalt, this.getU());
            if (Arrays.equals(hash, oHash)) {
                byte[] oKeySalt = new byte[8];
                System.arraycopy(this.getO(), 40, oKeySalt, 0, 8);
                hash = this.computeHash2A(password, oKeySalt, this.getU());
                fileEncryptionKey = this.getOE();
            } else {
                byte[] uKeySalt = new byte[8];
                System.arraycopy(this.getU(), 40, uKeySalt, 0, 8);
                hash = this.computeHash2A(password, uKeySalt, null);
                fileEncryptionKey = this.getUE();
            }
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)new SecretKeySpec(hash, ALGORITHM_AES), new IvParameterSpec(new byte[16]));
            return cipher.doFinal(fileEncryptionKey);
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    @Override
    protected byte[] createOwnerPassword(byte[] owner, byte[] user) throws COSSecurityException {
        try {
            if (this.random == null) {
                this.random = CryptoTools.createSecureRandom();
            }
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            this.setCryptKey(new byte[32]);
            this.random.nextBytes(this.getCryptKey());
            if (owner == null) {
                owner = "".getBytes();
            }
            if (user == null) {
                user = "".getBytes();
            }
            if (owner.length == 0) {
                owner = user;
            }
            String ownerPasswordSasl = SaslPrep.saslPrepStored(new String(owner));
            String userPasswordSasl = SaslPrep.saslPrepStored(new String(user));
            byte[] userPasswd = this.truncate(userPasswordSasl.getBytes(), 127);
            byte[] userValidationSalt = new byte[8];
            byte[] userKeySalt = new byte[8];
            this.random.nextBytes(userValidationSalt);
            this.random.nextBytes(userKeySalt);
            byte[] hashU = this.computeHash2B(this.concat(userPasswd, userValidationSalt), userPasswd, null);
            byte[] u = this.concat(hashU, userValidationSalt, userKeySalt);
            byte[] hashUE = this.computeHash2B(this.concat(userPasswd, userKeySalt), userPasswd, null);
            cipher.init(1, (Key)new SecretKeySpec(hashUE, ALGORITHM_AES), new IvParameterSpec(new byte[16]));
            byte[] ue = cipher.doFinal(this.getCryptKey());
            byte[] ownerPasswordBytes = this.truncate(ownerPasswordSasl.getBytes(StandardCharsets.UTF_8), 127);
            byte[] ownerValidationSalt = new byte[8];
            byte[] ownerKeySalt = new byte[8];
            this.random.nextBytes(ownerValidationSalt);
            this.random.nextBytes(ownerKeySalt);
            byte[] hashO = this.computeHash2B(this.concat(ownerPasswordBytes, ownerValidationSalt, u), ownerPasswordBytes, u);
            byte[] o = this.concat(hashO, ownerValidationSalt, ownerKeySalt);
            byte[] hashOE = this.computeHash2B(this.concat(ownerPasswordBytes, ownerKeySalt, u), ownerPasswordBytes, u);
            cipher.init(1, (Key)new SecretKeySpec(hashOE, ALGORITHM_AES), new IvParameterSpec(new byte[16]));
            byte[] oe = cipher.doFinal(this.getCryptKey());
            byte[] permrandom = new byte[16];
            this.random.nextBytes(permrandom);
            COSString uCos = COSString.create(u);
            this.getEncryption().cosSetField(COSName.constant("U"), uCos);
            COSString ueCos = COSString.create(ue);
            this.getEncryption().cosSetField(COSName.constant("UE"), ueCos);
            COSString oeCos = COSString.create(oe);
            this.getEncryption().cosSetField(COSName.constant("OE"), oeCos);
            int permissions = this.getPermissionFlags().getValue();
            byte[] perms = new byte[16];
            this.random.nextBytes(perms);
            perms[0] = (byte)permissions;
            perms[1] = (byte)(permissions >> 8);
            perms[2] = (byte)(permissions >> 16);
            perms[3] = (byte)(permissions >> 24);
            perms[4] = -1;
            perms[5] = -1;
            perms[6] = -1;
            perms[7] = -1;
            perms[8] = this.isEncryptMetadata() ? 84 : 70;
            perms[9] = 97;
            perms[10] = 100;
            perms[11] = 98;
            for (int i = 12; i <= 15; ++i) {
                perms[i] = (byte)this.random.nextInt();
            }
            cipher.init(1, (Key)new SecretKeySpec(this.getCryptKey(), ALGORITHM_AES), new IvParameterSpec(new byte[16]));
            byte[] permsEnc = cipher.doFinal(perms);
            COSString aesPerms = COSString.create(permsEnc);
            this.getEncryption().cosSetField(COSName.constant("Perms"), aesPerms);
            return o;
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    @Override
    protected byte[] createUserPassword(byte[] user) throws COSSecurityException {
        COSObject userPass = this.getEncryption().cosGetField(COSName.constant("U"));
        byte[] valueBytes = userPass.getValueBytes(null);
        return valueBytes;
    }

    @Override
    public int getRevision() {
        return 6;
    }

    private byte[] truncate(byte[] inputbyte, int length) {
        if (inputbyte.length <= length) {
            return inputbyte;
        }
        byte[] truncateByte = new byte[length];
        System.arraycopy(inputbyte, 0, truncateByte, 0, length);
        return truncateByte;
    }
}

