/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSNotSupported;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.ICSDeviceFeatures;
import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.content.TextState;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDPostScript;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.pdf.tools.kernel.PDFRenderException;
import de.intarsys.tools.geometry.ApplySpaceChangeShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public abstract class CSDeviceAdapter
implements ICSDevice,
ICSDeviceFeatures {
    public static final int MAX_STACK_SIZE = 500;
    private AffineTransform deviceTransform = new AffineTransform();
    protected GraphicsState graphicsState;
    private ICSInterpreter interpreter;
    private GraphicsState[] stack = new GraphicsState[500];
    private int stackPtr = 0;
    protected TextState textState;

    protected CSDeviceAdapter() {
    }

    protected void basicSetNonStrokeColorSpace(PDColorSpace colorSpace) {
        this.graphicsState.nonStrokeColorSpace = colorSpace;
        this.graphicsState.nonStrokeColorValues = null;
    }

    protected void basicSetNonStrokeColorValues(float[] values) {
        this.graphicsState.nonStrokeColorValues = values;
    }

    protected void basicSetStrokeColorSpace(PDColorSpace colorSpace) {
        this.graphicsState.strokeColorSpace = colorSpace;
        this.graphicsState.strokeColorValues = null;
    }

    protected void basicSetStrokeColorValues(float[] values) {
        this.graphicsState.strokeColorValues = values;
    }

    @Override
    public void close() {
        this.interpreter = null;
    }

    @Override
    public void compatibilityBegin() {
    }

    @Override
    public void compatibilityEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doForm(COSName name, PDForm form) throws CSException {
        this.saveState();
        try {
            CDSRectangle r;
            CDSMatrix m = form.getMatrix();
            if (m != null) {
                this.transform(m.getA(), m.getB(), m.getC(), m.getD(), m.getE(), m.getF());
            }
            if ((r = form.getBoundingBox()) != null) {
                Rectangle2D tempRect = r.toNormalizedRectangle();
                this.penRectangle((float)tempRect.getMinX(), (float)tempRect.getMinY(), (float)tempRect.getWidth(), (float)tempRect.getHeight());
                this.pathClipNonZero();
                this.pathEnd();
            }
            if (this.interpreter != null) {
                this.interpreter.process(form.getContentStream(), form.getResources());
            }
        }
        finally {
            this.restoreState();
        }
    }

    protected void doImage(COSName name, PDImage image) throws CSException {
    }

    protected void doPostScript(COSName name, PDPostScript postscript) throws CSException {
    }

    @Override
    public void doShading(COSName name, PDShading shading) {
    }

    @Override
    public void doXObject(COSName name, PDXObject xobject) {
        if (xobject == null) {
            return;
        }
        if (xobject.isForm()) {
            try {
                this.doForm(name, (PDForm)xobject);
            }
            catch (CSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSError("Unexpected error rendering form", e);
            }
        } else if (xobject.isImage()) {
            try {
                this.doImage(name, (PDImage)xobject);
            }
            catch (CSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSError("Unexpected error rendering image", e);
            }
        } else if (xobject.isPostscript()) {
            try {
                this.doPostScript(name, (PDPostScript)xobject);
            }
            catch (CSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSError("Unexpected error rendering postscript", e);
            }
        } else {
            throw new CSNotSupported("unknown XObject type");
        }
    }

    public AffineTransform getDeviceTransform() {
        return this.deviceTransform;
    }

    @Override
    public GraphicsState getGraphicsState() {
        return this.graphicsState;
    }

    @Override
    public ICSInterpreter getInterpreter() {
        return this.interpreter;
    }

    protected GraphicsState graphicsStateCopy(GraphicsState oldState) {
        return oldState.copy();
    }

    protected GraphicsState graphicsStateCreate() {
        return new GraphicsState();
    }

    @Override
    public void inlineImage(PDImage img) {
    }

    @Override
    public void markedContentBegin(COSName tag) {
    }

    @Override
    public void markedContentBeginProperties(COSName tag, COSName resourceName, COSDictionary properties) {
    }

    @Override
    public void markedContentEnd() {
    }

    @Override
    public void markedContentPoint(COSName tag) {
    }

    @Override
    public void markedContentPointProperties(COSName tag, COSName resourceName, COSDictionary properties) {
    }

    @Override
    public void open(ICSInterpreter pInterpreter) {
        this.interpreter = pInterpreter;
        this.graphicsState = this.graphicsStateCreate();
        this.textState = this.graphicsState.textState;
        this.basicSetNonStrokeColorSpace(PDCSDeviceGray.SINGLETON);
        this.basicSetNonStrokeColorValues(new float[]{0.0f});
        this.basicSetStrokeColorSpace(PDCSDeviceGray.SINGLETON);
        this.basicSetStrokeColorValues(new float[]{0.0f});
    }

    @Override
    public void pathClipEvenOdd() {
    }

    @Override
    public void pathClipNonZero() {
    }

    @Override
    public void pathClose() {
    }

    @Override
    public void pathCloseFillStrokeEvenOdd() {
    }

    @Override
    public void pathCloseFillStrokeNonZero() {
    }

    @Override
    public void pathCloseStroke() {
    }

    @Override
    public void pathEnd() {
    }

    @Override
    public void pathFillEvenOdd() {
    }

    @Override
    public void pathFillNonZero() {
    }

    @Override
    public void pathFillStrokeEvenOdd() {
    }

    @Override
    public void pathFillStrokeNonZero() {
    }

    @Override
    public void pathStroke() {
    }

    @Override
    public void penCurveToC(float x1, float y1, float x2, float y2, float x3, float y3) {
    }

    @Override
    public void penCurveToV(float x2, float y2, float x3, float y3) {
    }

    @Override
    public void penCurveToY(float x1, float y1, float x3, float y3) {
    }

    @Override
    public void penLineTo(float x, float y) {
    }

    @Override
    public void penMoveTo(float x, float y) {
    }

    @Override
    public void penRectangle(float x, float y, float w, float h) {
    }

    @Override
    public void restoreState() {
        if (this.stackPtr == 0) {
            throw new PDFRenderException("stack underflow");
        }
        --this.stackPtr;
        this.graphicsState = this.stack[this.stackPtr];
        this.textState = this.graphicsState.textState;
    }

    @Override
    public void saveState() {
        if (this.stackPtr == 500) {
            throw new PDFRenderException("stack overflow");
        }
        this.stack[this.stackPtr++] = this.graphicsState;
        this.graphicsState = this.graphicsStateCopy(this.graphicsState);
        this.textState = this.graphicsState.textState;
    }

    public void setDeviceTransform(AffineTransform deviceTransform) {
        this.deviceTransform = deviceTransform;
    }

    @Override
    public void setExtendedState(COSName name, PDExtGState gstate) {
        if (gstate == null) {
            return;
        }
        if (this.graphicsState.extState == null) {
            this.graphicsState.extState = (PDExtGState)PDExtGState.META.createFromCos(gstate.cosGetObject().copyShallow());
        } else {
            this.graphicsState.extState.cosGetDict().addAll(gstate.cosGetDict());
        }
        this.graphicsState.capStyle = gstate.getFieldInt(PDExtGState.DK_LC, this.graphicsState.capStyle);
        COSArray cosDash = gstate.cosGetField(PDExtGState.DK_D).asArray();
        if (cosDash != null && cosDash.size() == 2) {
            COSArray cosPattern = cosDash.get(0).asArray();
            COSNumber cosPhase = cosDash.get(1).asNumber();
            if (cosPattern != null && cosPhase != null) {
                float[] pattern = new float[cosPattern.size()];
                for (int index = 0; index < cosPattern.size(); ++index) {
                    COSNumber number = cosPattern.get(index).asNumber();
                    pattern[index] = number == null ? 0.0f : number.floatValue();
                }
                this.graphicsState.dashPattern = pattern;
                this.graphicsState.dashPhase = cosPhase.intValue();
            }
        }
        this.graphicsState.joinStyle = gstate.getFieldInt(PDExtGState.DK_LJ, this.graphicsState.joinStyle);
        this.setMiterLimit(gstate.getFieldFixed(PDExtGState.DK_ML, this.graphicsState.miterLimit));
        this.setLineWidth(gstate.getFieldFixed(PDExtGState.DK_LW, this.graphicsState.lineWidth));
        this.graphicsState.strokeAlphaValue = gstate.getFieldFixed(PDExtGState.DK_CA, this.graphicsState.strokeAlphaValue);
        this.graphicsState.nonStrokeAlphaValue = gstate.getFieldFixed(PDExtGState.DK_ca, this.graphicsState.nonStrokeAlphaValue);
    }

    @Override
    public void setFlatnessTolerance(float flatness) {
    }

    @Override
    public void setLineCap(int capStyle) {
        this.graphicsState.capStyle = capStyle;
    }

    @Override
    public void setLineDash(float[] pattern, float phase) {
        this.graphicsState.dashPattern = pattern;
        this.graphicsState.dashPhase = phase;
    }

    @Override
    public void setLineJoin(int joinStyle) {
        this.graphicsState.joinStyle = joinStyle;
    }

    @Override
    public void setLineWidth(float lineWidth) {
        this.graphicsState.lineWidth = lineWidth;
    }

    @Override
    public void setMiterLimit(float miterLimit) {
        this.graphicsState.miterLimit = miterLimit;
    }

    @Override
    public void setNonStrokeColorCMYK(float c, float m, float y, float k) {
        float[] values;
        PDCSDeviceCMYK colorSpace = PDCSDeviceCMYK.SINGLETON;
        if (this.graphicsState.nonStrokeColorSpace != colorSpace) {
            this.basicSetNonStrokeColorSpace(colorSpace);
        }
        if (!Arrays.equals(this.graphicsState.nonStrokeColorValues, values = new float[]{c, m, y, k})) {
            this.basicSetNonStrokeColorValues(values);
        }
    }

    @Override
    public void setNonStrokeColorGray(float gray) {
        float[] values;
        PDCSDeviceGray colorSpace = PDCSDeviceGray.SINGLETON;
        if (this.graphicsState.nonStrokeColorSpace != colorSpace) {
            this.basicSetNonStrokeColorSpace(colorSpace);
        }
        if (!Arrays.equals(this.graphicsState.nonStrokeColorValues, values = new float[]{gray})) {
            this.basicSetNonStrokeColorValues(values);
        }
    }

    @Override
    public void setNonStrokeColorRGB(float r, float g, float b) {
        float[] values;
        PDCSDeviceRGB colorSpace = PDCSDeviceRGB.SINGLETON;
        if (this.graphicsState.nonStrokeColorSpace != colorSpace) {
            this.basicSetNonStrokeColorSpace(colorSpace);
        }
        if (!Arrays.equals(this.graphicsState.nonStrokeColorValues, values = new float[]{r, g, b})) {
            this.basicSetNonStrokeColorValues(values);
        }
    }

    @Override
    public void setNonStrokeColorSpace(COSName name, PDColorSpace colorSpace) {
        this.basicSetNonStrokeColorSpace(colorSpace);
    }

    @Override
    public void setNonStrokeColorValues(float[] values) {
        if (!Arrays.equals(this.graphicsState.nonStrokeColorValues, values)) {
            this.basicSetNonStrokeColorValues(values);
        }
    }

    @Override
    public void setNonStrokeColorValues(float[] values, COSName name, PDPattern pattern) {
    }

    @Override
    public void setRenderingIntent(COSName intent) {
    }

    @Override
    public void setStrokeColorCMYK(float c, float m, float y, float k) {
        float[] values;
        PDCSDeviceCMYK colorSpace = PDCSDeviceCMYK.SINGLETON;
        if (this.graphicsState.strokeColorSpace != colorSpace) {
            this.basicSetStrokeColorSpace(colorSpace);
        }
        if (!Arrays.equals(this.graphicsState.strokeColorValues, values = new float[]{c, m, y, k})) {
            this.basicSetStrokeColorValues(values);
        }
    }

    @Override
    public void setStrokeColorGray(float gray) {
        float[] values;
        PDCSDeviceGray colorSpace = PDCSDeviceGray.SINGLETON;
        if (this.graphicsState.strokeColorSpace != colorSpace) {
            this.basicSetStrokeColorSpace(colorSpace);
        }
        if (!Arrays.equals(this.graphicsState.strokeColorValues, values = new float[]{gray})) {
            this.basicSetStrokeColorValues(values);
        }
    }

    @Override
    public void setStrokeColorRGB(float r, float g, float b) {
        float[] values;
        PDCSDeviceRGB colorSpace = PDCSDeviceRGB.SINGLETON;
        if (this.graphicsState.strokeColorSpace != colorSpace) {
            this.basicSetStrokeColorSpace(colorSpace);
        }
        if (!Arrays.equals(this.graphicsState.strokeColorValues, values = new float[]{r, g, b})) {
            this.basicSetStrokeColorValues(values);
        }
    }

    @Override
    public void setStrokeColorSpace(COSName name, PDColorSpace colorSpace) {
        this.basicSetStrokeColorSpace(colorSpace);
    }

    @Override
    public void setStrokeColorValues(float[] values) {
        if (!Arrays.equals(this.graphicsState.strokeColorValues, values)) {
            this.basicSetStrokeColorValues(values);
        }
    }

    @Override
    public void setStrokeColorValues(float[] values, COSName name, PDPattern pattern) {
    }

    @Override
    public boolean supportsColorSpace() {
        return true;
    }

    @Override
    public boolean supportsExtendedState() {
        return true;
    }

    @Override
    public boolean supportsFont() {
        return true;
    }

    @Override
    public boolean supportsInlineImage() {
        return true;
    }

    @Override
    public boolean supportsPattern() {
        return true;
    }

    @Override
    public boolean supportsProperties() {
        return true;
    }

    @Override
    public boolean supportsShading() {
        return true;
    }

    @Override
    public boolean supportsXObject() {
        return true;
    }

    @Override
    public void textBegin() {
        this.textState.lineTransform.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.textState.transform.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.textState.globalTransform.setTransform(this.graphicsState.transform);
        this.textState.active = true;
    }

    @Override
    public void textEnd() {
        this.textState.active = false;
    }

    @Override
    public void textLineMove(float dx, float dy) {
        this.textState.lineTransform.translate(dx, dy);
        this.textState.transform.setTransform(this.textState.lineTransform);
        this.textState.globalTransform.setTransform(this.graphicsState.transform);
        this.textState.globalTransform.concatenate(this.textState.transform);
    }

    @Override
    public void textLineNew() {
        this.textState.lineTransform.translate(0.0, this.textState.leading);
        this.textState.transform.setTransform(this.textState.lineTransform);
        this.textState.globalTransform.setTransform(this.graphicsState.transform);
        this.textState.globalTransform.concatenate(this.textState.transform);
    }

    @Override
    public void textMove(float dx, float dy) {
        this.textState.transform.translate(dx, dy);
        this.textState.globalTransform.translate(dx, dy);
    }

    @Override
    public void textMoveTo(float x, float y) {
        float dx = x - (float)this.textState.transform.getTranslateX();
        float dy = y - (float)this.textState.transform.getTranslateY();
        this.textMove(dx, dy);
    }

    @Override
    public void textSetCharSpacing(float charSpacing) {
        this.textState.charSpacing = charSpacing;
        this.textState.derivedCharSpacingScaled = this.textState.charSpacing * this.textState.derivedHorizontalScalingFactor;
    }

    @Override
    public void textSetFont(COSName name, PDFont font, float size) {
        this.textState.font = font;
        this.textState.fontSize = size;
        this.textState.derivedGlyphAdvanceFactor = this.textState.fontSize / 1000.0f * this.textState.derivedHorizontalScalingFactor;
    }

    @Override
    public void textSetHorizontalScaling(float scaling) {
        this.textState.horizontalScaling = scaling;
        this.textState.derivedHorizontalScalingFactor = this.textState.horizontalScaling / 100.0f;
        this.textState.derivedGlyphAdvanceFactor = this.textState.fontSize / 1000.0f * this.textState.derivedHorizontalScalingFactor;
        this.textState.derivedCharSpacingScaled = this.textState.charSpacing * this.textState.derivedHorizontalScalingFactor;
        this.textState.derivedWordSpacingScaled = this.textState.wordSpacing * this.textState.derivedHorizontalScalingFactor;
    }

    @Override
    public void textSetLeading(float leading) {
        this.textState.leading = leading;
    }

    @Override
    public void textSetRenderingMode(int renderingMode) {
        this.textState.renderingMode = renderingMode;
    }

    @Override
    public void textSetRise(float rise) {
        this.textState.rise = rise;
    }

    @Override
    public void textSetTransform(float a, float b, float c, float d, float e, float f) {
        this.textState.lineTransform.setTransform(a, b, c, d, e, f);
        this.textState.transform.setTransform(a, b, c, d, e, f);
        this.textState.globalTransform.setTransform(this.graphicsState.transform);
        this.textState.globalTransform.concatenate(this.textState.transform);
    }

    @Override
    public void textSetWordSpacing(float wordSpacing) {
        this.textState.wordSpacing = wordSpacing;
        this.textState.derivedWordSpacingScaled = this.textState.wordSpacing * this.textState.derivedHorizontalScalingFactor;
    }

    @Override
    public void textShow(byte[] text, int offset, int length) {
    }

    @Override
    public void textShow(char[] chars, int offset, int length) {
        byte[] bytes = this.textState.font.getEncoding().encode(chars, offset, length);
        this.textShow(bytes, 0, bytes.length);
    }

    @Override
    public void textShow(String text) {
        byte[] bytes = this.textState.font.getEncoding().encode(text.toCharArray(), 0, text.length());
        this.textShow(bytes, 0, bytes.length);
    }

    @Override
    public void textT3SetGlyphWidth(float x, float y) {
    }

    @Override
    public void textT3SetGlyphWidthBB(float x, float y, float llx, float lly, float urx, float ury) {
    }

    @Override
    public void transform(float a, float b, float c, float d, float e, float f) {
        AffineTransform transform = new AffineTransform(a, b, c, d, e, f);
        transform.preConcatenate(this.graphicsState.transform);
        this.graphicsState.transform = transform;
        if (this.graphicsState.clip != null) {
            this.graphicsState.clip = ApplySpaceChangeShape.setTransform((Shape)this.graphicsState.clip, (AffineTransform)this.graphicsState.transform);
        }
    }
}

