/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.observer;

import de.intarsys.pdf.app.observer.COSAspectWatchdog;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSPrimitiveObject;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.tools.component.IStartStop;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class COSAbstractWatchdog
implements IStartStop {
    private volatile boolean started = false;
    private Object watched;
    private List childWatchdogs;
    private Object lifecycleLock = new Object();

    protected COSAbstractWatchdog() {
    }

    public void addChildWatchdog(COSAspectWatchdog child) {
        if (this.childWatchdogs == null) {
            this.childWatchdogs = new ArrayList();
        }
        child.setParent(this);
        this.childWatchdogs.add(child);
        if (this.isStarted()) {
            Object nextWatched;
            try {
                nextWatched = this.getChildObject();
            }
            catch (RuntimeException e) {
                return;
            }
            if (nextWatched == null || nextWatched instanceof COSNull) {
                return;
            }
            child.setWatched(nextWatched);
            child.start();
        }
    }

    protected void basicStart() {
    }

    protected void basicStop() {
    }

    protected boolean basicStopRequested(Set visited) {
        return true;
    }

    public void clearChildWatchdogs() {
        if (this.childWatchdogs == null) {
            return;
        }
        if (this.isStarted()) {
            this.stopChildren();
        }
        for (COSAspectWatchdog childWatchdog : this.childWatchdogs) {
            childWatchdog.stop();
            childWatchdog.setParent(null);
        }
        this.childWatchdogs.clear();
    }

    protected abstract Object getChildObject();

    public List getChildWatchdogs() {
        if (this.childWatchdogs == null) {
            return Collections.emptyList();
        }
        return new ArrayList(this.childWatchdogs);
    }

    public Object getWatched() {
        return this.watched;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void removeChildWatchdog(COSAspectWatchdog child) {
        if (this.childWatchdogs == null) {
            return;
        }
        if (this.childWatchdogs.remove(child)) {
            child.setParent(null);
            if (this.isStarted()) {
                child.stop();
            }
        }
    }

    public void setWatched(Object pWatched) {
        if (this.isStarted()) {
            throw new IllegalStateException("watchdog must be stopped");
        }
        this.watched = pWatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.basicStart();
            this.started = true;
        }
        this.startChildren();
    }

    protected void startChildren() {
        Object childObject;
        if (this.childWatchdogs == null) {
            return;
        }
        try {
            childObject = this.getChildObject();
        }
        catch (RuntimeException e) {
            return;
        }
        if (childObject == null || childObject instanceof COSPrimitiveObject) {
            return;
        }
        for (COSAspectWatchdog childWatchdog : this.childWatchdogs) {
            childWatchdog.setWatched(childObject);
            childWatchdog.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.basicStop();
            this.started = false;
        }
        this.stopChildren();
    }

    protected void stopChildren() {
        if (this.childWatchdogs == null) {
            return;
        }
        for (COSAspectWatchdog childWatchdog : this.childWatchdogs) {
            childWatchdog.stop();
        }
    }

    public boolean stopRequested(Set visited) {
        if (visited != null) {
            if (visited.contains(this)) {
                return true;
            }
            visited.add(this);
        }
        return this.basicStopRequested(visited);
    }

    public COSAspectWatchdog watch(Object pSlot, ICOSObjectListener pListener) {
        COSAspectWatchdog child = new COSAspectWatchdog(pSlot, pListener);
        this.addChildWatchdog(child);
        return child;
    }
}

