/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance;

import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.app.appearance.IAppearanceCreatorRegistry;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.tools.provider.ProviderTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StandardAppearanceCreatorRegistry
implements IAppearanceCreatorRegistry {
    private Map<COSName, IAppearanceCreator> instances = new HashMap<COSName, IAppearanceCreator>();
    private boolean initialized = false;
    private boolean lookupProviders = true;

    protected IAppearanceCreator[] findProviders() {
        ArrayList<IAppearanceCreator> result = new ArrayList<IAppearanceCreator>();
        Iterator ps = ProviderTools.providers(IAppearanceCreator.class);
        while (ps.hasNext()) {
            result.add((IAppearanceCreator)ps.next());
        }
        return result.toArray(new IAppearanceCreator[result.size()]);
    }

    @Override
    public synchronized IAppearanceCreator[] getAppearanceCreators() {
        this.init();
        return this.instances.values().toArray(new IAppearanceCreator[this.instances.size()]);
    }

    protected void init() {
        if (!this.lookupProviders || this.initialized) {
            return;
        }
        this.initialized = true;
        IAppearanceCreator[] providers = this.findProviders();
        for (int i = 0; i < providers.length; ++i) {
            IAppearanceCreator provider = providers[i];
            this.registerAppearanceCreator(provider);
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    @Override
    public synchronized IAppearanceCreator lookupAppearanceCreator(COSName type) {
        this.init();
        return this.instances.get(type);
    }

    @Override
    public synchronized void registerAppearanceCreator(IAppearanceCreator creator) {
        this.instances.put(creator.getAnnotationType(), creator);
    }

    public void setLookupProviders(boolean lookupProviders) {
        this.lookupProviders = lookupProviders;
    }

    @Override
    public synchronized void unregisterAppearanceCreator(IAppearanceCreator creator) {
        this.instances.remove(creator.getAnnotationType());
    }
}

