/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.acroform;

import de.intarsys.pdf.app.acroform.CommonFormHandler;
import de.intarsys.pdf.app.action.ActionTools;
import de.intarsys.pdf.app.action.TriggerEvent;
import de.intarsys.pdf.app.appearance.AppearanceCreatorTools;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAFButtonField;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.tools.string.Converter;
import java.util.HashMap;
import java.util.List;

public class StandardFormHandler
extends CommonFormHandler {
    protected StandardFormHandler(PDDocument doc) {
        super(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void basicRecalculate(PDAcroFormField source) {
        if (!this.isCalculate()) {
            return;
        }
        try {
            this.setCalculate(false);
            List co = this.getAcroForm().getCalculationOrder();
            if (co == null) {
                return;
            }
            for (PDAcroFormField field : co) {
                this.recalculateField(source, field);
            }
        }
        finally {
            this.setCalculate(true);
        }
    }

    @Override
    protected void basicSetFieldValue(PDAcroFormField field, List value) {
        if (field == null) {
            return;
        }
        PDAcroFormField rootField = field.getLogicalRoot();
        COSObject oldValue = rootField.cosGetValue();
        rootField.setValueStrings(value);
        COSObject newValue = rootField.cosGetValue();
        if (this.changed(oldValue, newValue)) {
            this.createAppearance(rootField);
            this.recalculate(rootField);
        }
    }

    @Override
    protected void basicSetFieldValue(PDAcroFormField field, PDSignature value) {
        if (field == null) {
            return;
        }
        PDAcroFormField rootField = field.getLogicalRoot();
        if (!rootField.isTypeSig()) {
            throw new IllegalArgumentException("signature field expected");
        }
        PDAFSignatureField sigField = (PDAFSignatureField)rootField;
        COSObject oldValue = sigField.cosGetValue();
        sigField.setSignature(value);
        COSObject newValue = sigField.cosGetValue();
        if (this.changed(oldValue, newValue)) {
            this.recalculate(sigField);
        }
    }

    @Override
    protected void basicSetFieldValue(PDAcroFormField field, String value) {
        if (field == null) {
            return;
        }
        PDAcroFormField rootField = field.getLogicalRoot();
        if (rootField.isTypeBtn() && ((PDAFButtonField)rootField).isPushbutton()) {
            this.basicSetFieldValuePushbutton(rootField, value);
        } else {
            this.basicSetFieldValueDefault(rootField, value);
        }
    }

    protected void basicSetFieldValueDefault(PDAcroFormField rootField, String value) {
        if (this.isValidate()) {
            TriggerEvent trigger = this.triggerValidate(rootField, value);
            if (!trigger.getRc()) {
                return;
            }
            value = trigger.getValueString();
        }
        COSObject oldValue = rootField.cosGetValue();
        rootField.setValueString(value);
        COSObject newValue = rootField.cosGetValue();
        if (this.changed(oldValue, newValue)) {
            this.createAppearance(rootField);
            this.recalculate(rootField);
        }
    }

    protected void basicSetFieldValuePushbutton(PDAcroFormField rootField, String value) {
        HashMap properties = null;
        properties = value == null ? new HashMap() : Converter.asMap((String)value);
        String label = (String)properties.get("label");
        String icon = (String)properties.get("icon");
    }

    protected boolean changed(Object oldValue, Object newValue) {
        boolean changed = false;
        if (oldValue == null) {
            if (newValue != null) {
                changed = true;
            }
        } else {
            changed = !oldValue.equals(newValue);
        }
        return changed;
    }

    protected void createAppearance(PDAcroFormField field) {
        if (field.isTypeBtn()) {
            return;
        }
        AppearanceCreatorTools.createAppearance(field.getLogicalRoot());
    }

    @Override
    protected void doResetFields(List fields) {
        for (PDAcroFormField field : fields) {
            field.reset();
            AppearanceCreatorTools.setAppearanceCreator(field.getLogicalRoot(), null);
            this.createAppearance(field);
        }
        this.recalculate();
    }

    protected void recalculateField(PDAcroFormField source, PDAcroFormField field) {
        String newFieldValue;
        String fieldValue = field.getValueString();
        TriggerEvent trigger = this.triggerCalculate(field, fieldValue, source);
        if (trigger.getRc() && (newFieldValue = trigger.getValueString()) != null && !newFieldValue.equals(fieldValue)) {
            field.setValueString(trigger.getValueString());
            this.createAppearance(field);
        }
    }

    protected TriggerEvent triggerCalculate(PDAcroFormField field, String value, PDAcroFormField source) {
        return ActionTools.fieldTriggerCalculate(field, value, source);
    }

    protected TriggerEvent triggerValidate(PDAcroFormField field, String value) {
        return ActionTools.fieldTriggerValidate(field, value);
    }
}

