/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.bytes;

import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.crypto.api.IByteStreamProvider;
import de.intarsys.tools.crypto.api.IKeyDerivationFunction;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class DerivedByteProvider
implements IByteProvider,
IByteStreamProvider {
    private IKeyDerivationFunction kdf;
    private IByteProvider inputProvider;
    private int size = -1;

    @Override
    public byte[] getBytes() throws IOException {
        try {
            byte[] tmpInput = this.getInputProvider().getBytes();
            if (this.getSize() == -1) {
                throw new IOException("size undefined");
            }
            return this.getKdf().derive(tmpInput, this.getSize());
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte[] getBytes(int length) throws IOException {
        try {
            byte[] tmpInput = this.getInputProvider().getBytes();
            return this.getKdf().derive(tmpInput, length);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public IByteProvider getInputProvider() {
        return this.inputProvider;
    }

    public IKeyDerivationFunction getKdf() {
        return this.kdf;
    }

    public int getSize() {
        return this.size;
    }

    @PostConstruct
    public void init() {
        if (this.kdf == null) {
            throw new IllegalArgumentException("kdf is required for derivation");
        }
        if (this.inputProvider == null) {
            throw new IllegalArgumentException("inputProvider is required for derivation");
        }
    }

    public void setInputProvider(IByteProvider inputProvider) {
        this.inputProvider = inputProvider;
    }

    public void setKdf(IKeyDerivationFunction kdf) {
        this.kdf = kdf;
    }

    public void setSize(int length) {
        this.size = length;
    }
}

