/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.PACKAGE;
import de.intarsys.security.validation.IQCInfo;
import de.intarsys.security.validation.IVSQualification;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.PrettyPrinter;

public abstract class VSQualification
extends CommonValidationState
implements IVSQualification {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private CommonPKIProfile validityPolicyID;
    private boolean digestAlgorithmUpToDate = true;
    private boolean signatureAlgorithmUpToDate = true;
    private IQCInfo qcInfo;

    protected VSQualification(IValidationTarget target) {
        super(target);
    }

    protected VSQualification(IValidationTarget target, int state) {
        super(target, state);
    }

    @Override
    public IQCInfo getQcInfo() {
        return this.qcInfo;
    }

    @Override
    public String getValidityPolicy() {
        if (this.getValidityPolicyID() == null) {
            return null;
        }
        return this.getValidityPolicyID().getDescription();
    }

    @Override
    public CommonPKIProfile getValidityPolicyID() {
        return this.validityPolicyID;
    }

    @Override
    public boolean isDigestAlgorithmUpToDate() {
        return this.digestAlgorithmUpToDate;
    }

    @Override
    public boolean isSignatureAlgorithmUpToDate() {
        return this.signatureAlgorithmUpToDate;
    }

    public void setDigestAlgorithmUpToDate(boolean digestAlgorithmUpToDate) {
        this.digestAlgorithmUpToDate = digestAlgorithmUpToDate;
    }

    public void setQcInfo(IQCInfo qcInfo) {
        this.qcInfo = qcInfo;
    }

    public void setSignatureAlgorithmUpToDate(boolean signatureAlgorithmUpToDate) {
        this.signatureAlgorithmUpToDate = signatureAlgorithmUpToDate;
    }

    public void setValidityPolicyID(CommonPKIProfile validityPolicyId) {
        this.validityPolicyID = validityPolicyId;
    }

    @Override
    public void toString(PrettyPrinter printer) {
        super.toString(printer);
        printer.appendMember("policy", (Object)this.getValidityPolicy(), null);
    }
}

