/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.certificate.ITrustBase;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.VSDefault;
import de.intarsys.security.standard.validation.VSSignature;
import de.intarsys.security.standard.validation.VTCertificate;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IVSCRL;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IVSOCSP;
import de.intarsys.security.validation.IVSQualificationCertificate;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVTCertificate;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.Date;
import java.util.Set;

public class VSCertificate
extends CommonValidationState
implements IVSCertificate {
    private IVSCertificatePath certificatePathState;
    private IVSOCSP ocspState;
    private IVSCRL crlState;
    private IVSSignature signatureState;
    private IVSQualificationCertificate qcState;
    private Date referenceDate;
    private IValidationState validityPeriodState;

    public static IVSCertificate createInvalid(IMessage message) {
        return VSCertificate.createInvalid(null, message);
    }

    public static IVSCertificate createInvalid(IValidationMessage message) {
        VSCertificate state = new VSCertificate((IVTCertificate)null, 3);
        state.addMessage(message);
        return state;
    }

    public static IVSCertificate createInvalid(IX509Certificate certificate, IMessage message) {
        VSCertificate state = new VSCertificate(certificate, 3);
        state.addMessage(ValidationMessage.createError(message));
        return state;
    }

    public static IVSCertificate createInvalid(IX509Certificate certificate, IValidationMessage message) {
        VSCertificate state = new VSCertificate(certificate, 3);
        state.addMessage(message);
        return state;
    }

    public static IVSCertificate createInvalid(IX509Certificate certificate, String message) {
        VSCertificate state = new VSCertificate(certificate, 3);
        state.addMessage(ValidationMessage.createError(message));
        return state;
    }

    public static IVSCertificate createInvalid(String message) {
        return VSCertificate.createInvalid(null, message);
    }

    public VSCertificate(IVSCertificate state) {
        super(state);
    }

    public VSCertificate(IVTCertificate certificate) {
        super(certificate);
    }

    public VSCertificate(IVTCertificate certificate, int state) {
        super((IValidationTarget)certificate, state);
    }

    public VSCertificate(IX509Certificate certificate) {
        super(certificate == null ? null : new VTCertificate(certificate));
    }

    public VSCertificate(IX509Certificate certificate, int state) {
        super((IValidationTarget)(certificate == null ? null : new VTCertificate(certificate)), state);
    }

    @Override
    protected void copy(IValidationState state) {
        super.copy(state);
        IVSCertificate certState = (IVSCertificate)state;
        this.certificatePathState = certState.getCertificatePathState();
        this.crlState = certState.getCRLState();
        this.ocspState = certState.getOCSPState();
        this.qcState = certState.getQcState();
        this.signatureState = certState.getSignatureState();
        this.validityPeriodState = certState.getValidityPeriodState();
    }

    public Set getAdditionalInfoObjects() {
        IVSCertificate delegateState;
        Set<Object> infoObjects = super.getAdditionalInfoObjects();
        if (infoObjects.isEmpty() && (delegateState = this.getStateFromPath()) != null) {
            return delegateState.getAdditionalInfoObjects();
        }
        return infoObjects;
    }

    @Override
    public IVSCertificatePath getCertificatePathState() {
        return this.certificatePathState;
    }

    @Override
    public IVSCRL getCRLState() {
        IVSCertificate delegateState;
        if (this.crlState == null && (delegateState = this.getStateFromPath()) != null) {
            return delegateState.getCRLState();
        }
        return this.crlState;
    }

    @Override
    public IVSOCSP getOCSPState() {
        IVSCertificate delegateState;
        if (this.ocspState == null && (delegateState = this.getStateFromPath()) != null) {
            return delegateState.getOCSPState();
        }
        return this.ocspState;
    }

    @Override
    public IVSQualificationCertificate getQcState() {
        IVSCertificate delegateState;
        if (this.qcState == null && (delegateState = this.getStateFromPath()) != null) {
            return delegateState.getQcState();
        }
        return this.qcState;
    }

    @Override
    public Date getReferenceDate() {
        IVSCertificate delegateState;
        if (this.referenceDate == null && (delegateState = this.getStateFromPath()) != null) {
            return delegateState.getReferenceDate();
        }
        return this.referenceDate;
    }

    @Override
    public IVSSignature getSignatureState() {
        if (this.signatureState == null) {
            IVSSignature result = null;
            IVSCertificate delegateState = this.getStateFromPath();
            if (delegateState != null) {
                result = delegateState.getSignatureState();
            }
            if (result == null) {
                result = new VSSignature((IDigest)null);
            }
            return result;
        }
        return this.signatureState;
    }

    protected IVSCertificate getStateFromPath() {
        if (this.getCertificatePathState() == null) {
            return null;
        }
        if (this.getValidationTarget() == null) {
            return null;
        }
        return this.getCertificatePathState().getCertificateState(this.getX509Certificate());
    }

    @Override
    public ITrustBase getTrustBase() {
        if (this.getCertificatePathState() == null) {
            return null;
        }
        return this.getCertificatePathState().getTrustBase();
    }

    @Override
    public IValidationState getValidityPeriodState() {
        if (this.validityPeriodState == null) {
            IVSCertificate delegateState = this.getStateFromPath();
            if (delegateState != null) {
                return delegateState.getValidityPeriodState();
            }
            this.validityPeriodState = new VSDefault();
        }
        return this.validityPeriodState;
    }

    @Override
    public IX509Certificate getX509Certificate() {
        if (this.getValidationTarget() == null) {
            return null;
        }
        return (IX509Certificate)this.getValidationTarget().getImpl();
    }

    @Override
    public boolean isRecoverable() {
        if (!this.isUnknown()) {
            return false;
        }
        if (!this.isRecoverable(this.getSignatureState())) {
            return false;
        }
        if (!this.isRecoverable(this.getValidityPeriodState())) {
            return false;
        }
        if (!this.isRecoverable(this.getCertificatePathState())) {
            return false;
        }
        if (!this.isRecoverable(this.getOCSPState())) {
            return false;
        }
        if (!this.isRecoverable(this.getCRLState())) {
            return false;
        }
        return this.isRecoverable(this.getQcState());
    }

    public void setCertificatePathState(IVSCertificatePath certificatePathState) {
        this.certificatePathState = certificatePathState;
        this.increaseState(certificatePathState);
    }

    public void setCRLState(IVSCRL crlState) {
        this.crlState = crlState;
        this.increaseState(crlState);
    }

    public void setOCSPState(IVSOCSP ocspState) {
        this.ocspState = ocspState;
        this.increaseState(ocspState);
    }

    public void setQcState(IVSQualificationCertificate qcState) {
        this.qcState = qcState;
        if (qcState.getSeverity() == 0) {
            this.increaseState(qcState);
        }
    }

    public void setReferenceDate(Date referenceDate) {
        this.referenceDate = referenceDate;
    }

    public void setSignatureState(IVSSignature signatureState) {
        this.signatureState = signatureState;
        this.increaseState(signatureState);
    }

    public void setValidityPeriodState(IValidationState validityPeriodState) {
        this.validityPeriodState = validityPeriodState;
        this.increaseState(validityPeriodState);
        this.addMessages(validityPeriodState.getMessages());
    }

    @Override
    public void toString(PrettyPrinter printer) {
        super.toString(printer);
        printer.appendMember("referenceDate", (Object)this.getReferenceDate(), null);
        printer.appendMember("trustBase", (Object)this.getTrustBase(), null);
        printer.appendMember("certificatePathState", (Object)this.getCertificatePathState(), null);
        printer.appendMember("signatureState", (Object)this.getSignatureState(), null);
        printer.appendMember("validityPeriodState", (Object)this.getValidityPeriodState(), null);
        printer.appendMember("crlState", (Object)this.getCRLState(), null);
        printer.appendMember("ocspState", (Object)this.getOCSPState(), null);
        printer.appendMember("qcState", (Object)this.getQcState(), null);
    }
}

