/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.ssl;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.keystore.KeyStoreTools;
import de.intarsys.tools.crypto.Secret;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

public class KeyManagerTools {
    public static KeyManager[] createKeyManagers(IX509PublicKeyCertificate certificate, Secret password) throws IOException, GeneralSecurityException {
        KeyStore keystore = KeyStoreTools.createJavaKeyStore(certificate, password);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, password.getChars());
        KeyManager[] keyManagers = kmf.getKeyManagers();
        return keyManagers;
    }

    private KeyManagerTools() {
    }
}

