/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature.policy.common;

import de.intarsys.security.signature.policy.INoticeReference;
import de.intarsys.security.signature.policy.common.CommonQualifier;
import de.intarsys.security.signature.policy.common.ISPUserNoticeQualifier;
import de.intarsys.security.signature.policy.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;

public class SPUserNoticeQualifier
extends CommonQualifier
implements ISPUserNoticeQualifier {
    private INoticeReference noticeReference;
    private String explicitText;
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public SPUserNoticeQualifier(INoticeReference noticeReference, String explicitText) {
        this.noticeReference = noticeReference;
        this.explicitText = explicitText;
    }

    @Override
    public String getOID() {
        return "1.2.840.113549.1.9.16.5.2";
    }

    @Override
    public INoticeReference getNoticeReference() {
        return this.noticeReference;
    }

    @Override
    public String getExplicitText() {
        return this.explicitText;
    }

    @Override
    public String getStringValue() {
        StringBuilder sb = new StringBuilder();
        if (this.getNoticeReference() != null) {
            String organization = this.getNoticeReference().getOrganization();
            String notices = this.toString(this.getNoticeReference().getNoticeNumbers());
            String key = "SPUserNoticeQualifier.NoticeReference";
            if (this.getNoticeReference().getNoticeNumbers().length > 1) {
                key = "SPUserNoticeQualifier.NoticeReferenceN";
            }
            sb.append(Msg.getString(key, new Object[]{organization, notices})).append(StringTools.LS);
        }
        if (this.getExplicitText() != null) {
            sb.append(this.getExplicitText()).append(StringTools.LS);
        }
        return sb.toString();
    }

    protected String toString(int[] values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            sb.append(values[i]);
            if (i >= values.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public String getLabel() {
        return Msg.getString("SPUserNoticeQualifier.Label", new Object[0]);
    }
}

