/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature.etsi.api;

import de.intarsys.security.signature.etsi.api.ConformanceLevel;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ConformanceLevelTools {
    public static ConformanceLevel assessHighestCommonConformanceLevel(List<ConformanceLevel> levels) {
        if (levels == null || levels.isEmpty()) {
            return null;
        }
        boolean hasB = levels.contains((Object)ConformanceLevel.B);
        boolean hasV = levels.contains((Object)ConformanceLevel.V);
        boolean hasT = levels.contains((Object)ConformanceLevel.T);
        if (hasB || hasV && hasT) {
            return ConformanceLevel.B;
        }
        if (hasV) {
            return ConformanceLevel.V;
        }
        if (hasT) {
            return ConformanceLevel.T;
        }
        if (levels.contains((Object)ConformanceLevel.LT)) {
            return ConformanceLevel.LT;
        }
        return ConformanceLevel.LTA;
    }

    public static List<ConformanceLevel> evaluateContainerStateConformanceLevel(IVSSignatureContainer containerState) {
        ArrayList<ConformanceLevel> entryStateConformanceLevels = new ArrayList<ConformanceLevel>();
        for (IVSSignatureContainerEntry entryState : containerState.getEntryStates()) {
            ConformanceLevelTools.getConformanceLevelFromIVSEntryState(entryState).ifPresent(entryStateConformanceLevels::add);
        }
        return entryStateConformanceLevels;
    }

    public static Optional<ConformanceLevel> getConformanceLevelFromIVSEntryState(IVSSignatureContainerEntry entryState) {
        return entryState.getAdditionalInfoObjects().stream().filter(infoObject -> infoObject instanceof ConformanceLevel).map(infoObject -> (ConformanceLevel)((Object)((Object)infoObject))).findFirst();
    }

    public static boolean isAugmentationNecessary(ConformanceLevel targetLevel, ConformanceLevel currentLevel) {
        return switch (targetLevel) {
            case ConformanceLevel.LTA -> {
                if (currentLevel != ConformanceLevel.LTA) {
                    yield true;
                }
                yield false;
            }
            case ConformanceLevel.LT -> {
                if (currentLevel != ConformanceLevel.LTA && currentLevel != ConformanceLevel.LT) {
                    yield true;
                }
                yield false;
            }
            case ConformanceLevel.T -> {
                if (currentLevel != ConformanceLevel.LTA && currentLevel != ConformanceLevel.LT && currentLevel != ConformanceLevel.T) {
                    yield true;
                }
                yield false;
            }
            case ConformanceLevel.V -> {
                if (currentLevel != ConformanceLevel.LTA && currentLevel != ConformanceLevel.LT && currentLevel != ConformanceLevel.V) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

