/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature.etsi.api;

import java.util.HashMap;
import java.util.Map;

public enum ConformanceLevel {
    B(false, false),
    V(false, true),
    T(true, false),
    LT(true, true),
    LTA(true, true);

    private static final Map<String, ConformanceLevel> ALIASES;
    private final boolean requiresTimestamp;
    private final boolean requiresValidationData;

    private ConformanceLevel(boolean requiresTimestamp, boolean requiresValidationData) {
        this.requiresTimestamp = requiresTimestamp;
        this.requiresValidationData = requiresValidationData;
    }

    public static ConformanceLevel create(Object value) {
        String tmp;
        ConformanceLevel result;
        if (value == null) {
            return null;
        }
        if (value instanceof ConformanceLevel) {
            return (ConformanceLevel)((Object)value);
        }
        if (value instanceof String && (result = ALIASES.get(tmp = ((String)value).toLowerCase())) != null) {
            return result;
        }
        throw new IllegalArgumentException("conformance level " + value + " not supported");
    }

    public boolean isTimestampRequired() {
        return this.requiresTimestamp;
    }

    public boolean isValidationDataRequired() {
        return this.requiresValidationData;
    }

    static {
        ALIASES = new HashMap<String, ConformanceLevel>();
        ALIASES.put("b", B);
        ALIASES.put("v", V);
        ALIASES.put("t", T);
        ALIASES.put("lt", LT);
        ALIASES.put("lta", LTA);
        ALIASES.put("b-b", B);
        ALIASES.put("b-t", T);
        ALIASES.put("b-lt", LT);
        ALIASES.put("b-lta", LTA);
        ALIASES.put("http://www.etsi.org/ades/191x2/level/baseline/b-b#", B);
        ALIASES.put("http://www.etsi.org/ades/191x2/level/baseline/b-t#", T);
        ALIASES.put("http://www.etsi.org/ades/191x2/level/baseline/b-lt#", LT);
        ALIASES.put("http://www.etsi.org/ades/191x2/level/baseline/b-lta#", LTA);
        ALIASES.put("http://www.etsi.org/ades/etsits/level/baseline/b-b#", B);
        ALIASES.put("http://www.etsi.org/ades/etsits/level/baseline/b-t#", T);
        ALIASES.put("http://www.etsi.org/ades/etsits/level/baseline/b-lt#", LT);
        ALIASES.put("http://www.etsi.org/ades/etsits/level/baseline/b-lta#", LTA);
    }
}

