/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature;

import de.intarsys.security.app.validation.BasicSignatureContainerValidator;
import de.intarsys.security.app.validation.ISignatureContainerValidator;
import de.intarsys.security.signature.AbstractSignatureContainer;
import de.intarsys.security.signature.UnknownSignatureEntry;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import java.util.Collections;
import java.util.List;

public class UnknownSignatureContainer
extends AbstractSignatureContainer<UnknownSignatureEntry> {
    private boolean detached;
    private final UnknownSignatureEntry entry;
    private Exception exception;

    public UnknownSignatureContainer(byte[] signature, boolean detached) {
        super(signature);
        this.detached = detached;
        this.entry = this.createEntry();
    }

    public UnknownSignatureContainer(Exception e, boolean external) {
        super(null);
        this.exception = e;
        this.detached = external;
        this.entry = this.createEntry();
    }

    protected UnknownSignatureEntry createEntry() {
        return new UnknownSignatureEntry(this);
    }

    @Override
    protected ISignatureContainerValidator createSignatureContainerValidator() {
        return new BasicSignatureContainerValidator();
    }

    public byte[] getBytes() {
        return (byte[])this.getImpl();
    }

    @Override
    public List<UnknownSignatureEntry> getEntries() {
        return Collections.singletonList(this.getEntry());
    }

    public UnknownSignatureEntry getEntry() {
        return this.entry;
    }

    public Exception getException() {
        return this.exception;
    }

    public ILocator getLocator() {
        return new ByteArrayLocator(this.getBytes(), this.getTypedName(), "");
    }

    public String getTypedName() {
        return "unknown";
    }

    @Override
    public boolean isDetached() {
        return this.detached;
    }

    public boolean validate(IDigest refDigest) {
        return false;
    }
}

