/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.openssl;

import de.intarsys.tools.crypto.Secret;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public class PEMUtil {
    static byte[] crypt(boolean encrypt, String provider, byte[] bytes, Secret password, String dekAlgName, byte[] iv) throws IOException {
        SecretKey sKey;
        String alg;
        String padding;
        String blockMode;
        AlgorithmParameterSpec paramSpec;
        block24: {
            paramSpec = new IvParameterSpec(iv);
            blockMode = "CBC";
            padding = "PKCS5Padding";
            if (dekAlgName.endsWith("-CFB")) {
                blockMode = "CFB";
                padding = "NoPadding";
            }
            if (dekAlgName.endsWith("-ECB") || "DES-EDE".equals(dekAlgName) || "DES-EDE3".equals(dekAlgName)) {
                blockMode = "ECB";
                paramSpec = null;
            }
            if (dekAlgName.endsWith("-OFB")) {
                blockMode = "OFB";
                padding = "NoPadding";
            }
            try {
                if (dekAlgName.startsWith("DES-EDE")) {
                    alg = "DESede";
                    boolean des2 = !dekAlgName.startsWith("DES-EDE3");
                    sKey = PEMUtil.getKey(password, alg, 24, iv, des2);
                    break block24;
                }
                if (dekAlgName.startsWith("DES-")) {
                    alg = "DES";
                    sKey = PEMUtil.getKey(password, alg, 8, iv);
                    break block24;
                }
                if (dekAlgName.startsWith("BF-")) {
                    alg = "Blowfish";
                    sKey = PEMUtil.getKey(password, alg, 16, iv);
                    break block24;
                }
                if (dekAlgName.startsWith("RC2-")) {
                    alg = "RC2";
                    int keyBits = 128;
                    if (dekAlgName.startsWith("RC2-40-")) {
                        keyBits = 40;
                    } else if (dekAlgName.startsWith("RC2-64-")) {
                        keyBits = 64;
                    }
                    sKey = PEMUtil.getKey(password, alg, keyBits / 8, iv);
                    paramSpec = paramSpec == null ? new RC2ParameterSpec(keyBits) : new RC2ParameterSpec(keyBits, iv);
                    break block24;
                }
                if (dekAlgName.startsWith("AES-")) {
                    int keyBits;
                    alg = "AES";
                    byte[] salt = iv;
                    if (salt.length > 8) {
                        salt = new byte[8];
                        System.arraycopy(iv, 0, salt, 0, 8);
                    }
                    if (dekAlgName.startsWith("AES-128-")) {
                        keyBits = 128;
                    } else if (dekAlgName.startsWith("AES-192-")) {
                        keyBits = 192;
                    } else if (dekAlgName.startsWith("AES-256-")) {
                        keyBits = 256;
                    } else {
                        throw new IOException("unknown AES encryption with private key");
                    }
                    sKey = PEMUtil.getKey(password, "AES", keyBits / 8, salt);
                    break block24;
                }
                throw new IOException("unknown encryption with private key");
            }
            catch (GeneralSecurityException e) {
                throw new IOException("error using password", e);
            }
        }
        String transformation = alg + "/" + blockMode + "/" + padding;
        try {
            int mode;
            Cipher c = Cipher.getInstance(transformation, provider);
            int n = mode = encrypt ? 1 : 2;
            if (paramSpec == null) {
                c.init(mode, sKey);
            } else {
                c.init(mode, (Key)sKey, paramSpec);
            }
            return c.doFinal(bytes);
        }
        catch (Exception e) {
            throw new IOException("exception using cipher - please check password and data.", e);
        }
    }

    private static SecretKey getKey(Secret password, String algorithm, int keyLength, byte[] salt) throws GeneralSecurityException {
        return PEMUtil.getKey(password, algorithm, keyLength, salt, false);
    }

    private static SecretKey getKey(Secret password, String algorithm, int keyLength, byte[] salt, boolean des2) throws GeneralSecurityException {
        OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
        pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])password.getChars()), salt);
        KeyParameter keyParam = (KeyParameter)pGen.generateDerivedParameters(keyLength * 8);
        byte[] key = keyParam.getKey();
        if (des2 && key.length >= 24) {
            System.arraycopy(key, 0, key, 16, 8);
        }
        return new SecretKeySpec(key, algorithm);
    }
}

