/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.openssl;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.openssl.PEMObjectParser;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.locator.StringLocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class PEMTools {
    public static Object readObject(ILocator locator, IPasswordProvider passwordProvider) throws IOException {
        PemObject pemObject = PEMTools.readPEMObject(locator);
        return PEMTools.readObject(pemObject, passwordProvider);
    }

    public static Object readObject(PemObject pemObject, IPasswordProvider passwordProvider) throws IOException {
        PEMObjectParser parser = new PEMObjectParser();
        parser.setPasswordProvider(passwordProvider);
        return parser.parseObject(pemObject);
    }

    public static IX509PublicKeyCertificate readPEMCertificate(ILocator locator) throws IOException {
        Object obj;
        int pos;
        StringBuilder pem = new StringBuilder(LocatorTools.getString((ILocator)locator));
        char currentChar = pem.charAt(pos = pem.indexOf("-----BEGIN CERTIFICATE-----") + 27);
        if (currentChar != '\r' && currentChar != '\n') {
            pem = pem.insert(pos, "\r\n");
        }
        if ((currentChar = pem.charAt((pos = pem.indexOf("-----END CERTIFICATE-----")) - 1)) != '\r' && currentChar != '\n') {
            pem = pem.insert(pos, "\r\n");
        }
        if (!((obj = PEMTools.readObject((ILocator)new StringLocator(pem.toString(), locator.getPath()), null)) instanceof X509Certificate)) {
            throw new IOException("invalid object type");
        }
        X509Certificate jCert = (X509Certificate)obj;
        return CertificateTools.wrapJavaCert(jCert);
    }

    public static PrivateKey readPEMKey(ILocator locator, IPasswordProvider passwordProvider) throws IOException {
        Object obj = PEMTools.readObject(locator, passwordProvider);
        if (obj instanceof PrivateKey) {
            PrivateKey key = (PrivateKey)obj;
            return key;
        }
        if (obj instanceof KeyPair) {
            KeyPair keyPair = (KeyPair)obj;
            return keyPair.getPrivate();
        }
        throw new IOException("invalid object type");
    }

    public static KeyPair readPEMKeyPair(ILocator locator, IPasswordProvider passwordProvider) throws IOException {
        Object obj = PEMTools.readObject(locator, passwordProvider);
        if (!(obj instanceof KeyPair)) {
            throw new IOException("invalid object type");
        }
        KeyPair keyPair = (KeyPair)obj;
        return keyPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PemObject readPEMObject(ILocator locator) throws IOException {
        Reader r = null;
        try {
            r = locator.getReader();
            PemReader reader = new PemReader(r);
            PemObject pemObject = reader.readPemObject();
            return pemObject;
        }
        finally {
            StreamTools.close((Closeable)r);
        }
    }
}

