/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.openssl;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.openssl.PEMUtil;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import java.util.StringTokenizer;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemHeader;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectParser;

public class PEMObjectParser
implements PemObjectParser {
    private IPasswordProvider passwordProvider;
    private String provider = "BC";

    protected String getHeader(PemObject obj, String name) {
        List headers = obj.getHeaders();
        for (PemHeader header : headers) {
            if (!name.equals(header.getName())) continue;
            return header.getValue();
        }
        return null;
    }

    public IPasswordProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    public Object parseObject(PemObject obj) throws IOException {
        String type = obj.getType();
        if ("CERTIFICATE".equals(type)) {
            return this.readCertificate(obj);
        }
        if ("PRIVATE KEY".equals(type)) {
            return this.readKey(obj);
        }
        if ("RSA PRIVATE KEY".equals(type)) {
            return this.readKeyPair(obj, "RSA");
        }
        if ("DSA PRIVATE KEY".equals(type)) {
            return this.readKeyPair(obj, "DSA");
        }
        throw new IOException("invalid object type");
    }

    protected X509Certificate readCertificate(PemObject obj) throws IOException {
        byte[] content = obj.getContent();
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509", this.provider);
            return (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(content));
        }
        catch (NoSuchProviderException e) {
            throw new IOException(e);
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
    }

    protected PrivateKey readKey(PemObject obj) throws IOException {
        byte[] keyDesc = obj.getContent();
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)keyDesc);
        AlgorithmIdentifier algId = privateKeyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier algOID = algId.getAlgorithm();
        String keyAlgo = null;
        if (!(algOID.equals((ASN1Primitive)PKCSObjectIdentifiers.rsaEncryption) || algOID.equals((ASN1Primitive)PKCSObjectIdentifiers.id_RSASSA_PSS) || algOID.equals((ASN1Primitive)X509ObjectIdentifiers.id_ea_rsa))) {
            throw new IOException("Unsupported key algorithm: " + algOID);
        }
        keyAlgo = "RSA";
        PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(privateKeyInfo.getPrivateKey().getOctets());
        try {
            KeyFactory fact = KeyFactory.getInstance(keyAlgo, this.provider);
            return fact.generatePrivate(privSpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        catch (NoSuchProviderException e) {
            throw new IOException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IOException(e);
        }
    }

    protected KeyPair readKeyPair(PemObject obj, String type) throws IOException {
        KeySpec privSpec;
        KeySpec pubSpec;
        byte[] keyBytes = obj.getContent();
        boolean isEncrypted = "4,ENCRYPTED".equals(this.getHeader(obj, "Proc-Type"));
        String dekInfo = this.getHeader(obj, "DEK-Info");
        if (isEncrypted) {
            if (this.getPasswordProvider() == null) {
                throw new IOException("No password finder specified, but a password is required");
            }
            Secret password = this.getPasswordProvider().getPassword();
            if (CryptoTools.isEmpty((Secret)password)) {
                throw new IOException("password is required");
            }
            StringTokenizer tknz = new StringTokenizer(dekInfo, ",");
            String dekAlgName = tknz.nextToken();
            byte[] iv = Hex.decode((String)tknz.nextToken());
            keyBytes = PEMUtil.crypt(false, this.provider, keyBytes, password, dekAlgName, iv);
        }
        ASN1Sequence seq = (ASN1Sequence)ASN1Tools.create((byte[])keyBytes);
        if (type.equals("RSA")) {
            ASN1Integer mod = (ASN1Integer)seq.getObjectAt(1);
            ASN1Integer pubExp = (ASN1Integer)seq.getObjectAt(2);
            ASN1Integer privExp = (ASN1Integer)seq.getObjectAt(3);
            ASN1Integer p1 = (ASN1Integer)seq.getObjectAt(4);
            ASN1Integer p2 = (ASN1Integer)seq.getObjectAt(5);
            ASN1Integer exp1 = (ASN1Integer)seq.getObjectAt(6);
            ASN1Integer exp2 = (ASN1Integer)seq.getObjectAt(7);
            ASN1Integer crtCoef = (ASN1Integer)seq.getObjectAt(8);
            pubSpec = new RSAPublicKeySpec(mod.getValue(), pubExp.getValue());
            privSpec = new RSAPrivateCrtKeySpec(mod.getValue(), pubExp.getValue(), privExp.getValue(), p1.getValue(), p2.getValue(), exp1.getValue(), exp2.getValue(), crtCoef.getValue());
        } else if (type.equals("ECDSA")) {
            ECPrivateKeyStructure pKey = new ECPrivateKeyStructure(seq);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)pKey.getParameters());
            PrivateKeyInfo privInfo = new PrivateKeyInfo(algId, (ASN1Encodable)pKey.toASN1Primitive());
            SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(algId, pKey.getPublicKey().getBytes());
            privSpec = new PKCS8EncodedKeySpec(privInfo.getEncoded());
            pubSpec = new X509EncodedKeySpec(pubInfo.getEncoded());
        } else {
            ASN1Integer p = (ASN1Integer)seq.getObjectAt(1);
            ASN1Integer q = (ASN1Integer)seq.getObjectAt(2);
            ASN1Integer g = (ASN1Integer)seq.getObjectAt(3);
            ASN1Integer y = (ASN1Integer)seq.getObjectAt(4);
            ASN1Integer x = (ASN1Integer)seq.getObjectAt(5);
            privSpec = new DSAPrivateKeySpec(x.getValue(), p.getValue(), q.getValue(), g.getValue());
            pubSpec = new DSAPublicKeySpec(y.getValue(), p.getValue(), q.getValue(), g.getValue());
        }
        try {
            KeyFactory fact = KeyFactory.getInstance(type, this.provider);
            return new KeyPair(fact.generatePublic(pubSpec), fact.generatePrivate(privSpec));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        catch (NoSuchProviderException e) {
            throw new IOException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IOException(e);
        }
    }

    public void setPasswordProvider(IPasswordProvider passwordProvider) {
        this.passwordProvider = passwordProvider;
    }
}

