/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.extension.common.CommonX509Extension;
import de.intarsys.security.extension.common.NetscapeCertificateType;
import java.io.IOException;
import org.bouncycastle.asn1.DERBitString;

public class X509ExtensionNetscapeCertificateType
extends CommonX509Extension {
    public static final String OID = "2.16.840.1.113730.1.1";
    private int type = 0;

    public static X509ExtensionNetscapeCertificateType create(byte[] encoded) throws IOException {
        DERBitString nct = NetscapeCertificateType.getInstance(ASN1Tools.create((byte[])encoded));
        return new X509ExtensionNetscapeCertificateType(nct.intValue());
    }

    public X509ExtensionNetscapeCertificateType() {
    }

    public X509ExtensionNetscapeCertificateType(int type) {
        this.setType(type);
    }

    public void addType(int type) {
        this.setType(this.getType() | type);
    }

    @Override
    public String getOid() {
        return OID;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public byte[] getValue() throws IOException {
        return new NetscapeCertificateType(this.getType()).getEncoded("DER");
    }

    public boolean isType(int type) {
        return (this.getType() & type) != 0;
    }

    public void setType(int type) {
        this.type = type;
    }
}

