/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;

public class PolicyConstraintsHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("PolicyConstraintsHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.5.29.36";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        ASN1Sequence derPolicyConstraints = (ASN1Sequence)CertificateTools.getExtensionValue(object, this.getOID());
        if (derPolicyConstraints == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Enumeration e = derPolicyConstraints.getObjects();
        while (e.hasMoreElements()) {
            ASN1TaggedObject policyConstraint = (ASN1TaggedObject)e.nextElement();
            switch (policyConstraint.getTagNo()) {
                case 0: {
                    int r = ASN1Integer.getInstance((Object)policyConstraint).getValue().intValue();
                    sb.append("requireExplicitPolicy: ").append(r).append(StringTools.LS);
                    break;
                }
                case 1: {
                    int q = ASN1Integer.getInstance((Object)policyConstraint).getValue().intValue();
                    sb.append("inhibitPolicyMapping: ").append(q).append(StringTools.LS);
                }
            }
        }
        return sb.toString();
    }
}

