/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider.keystore;

import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.keystore.IKeyStore;
import de.intarsys.security.certificate.provider.keystore.KeyStoreCertificateProvider;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFactory;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.exception.InitializationException;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class KeyStoreCertificateProviderFactoryBean
extends AbstractFactoryBean<KeyStoreCertificateProvider> {
    private IByteProvider keyStoreKeyProvider;
    private ILocator keyStoreLocator;
    private String keyStoreFileName;
    private Secret keyStorePassword;
    private ICertificateProvider certificateProvider;

    public KeyStoreCertificateProviderFactoryBean() {
        this.setSingleton(true);
    }

    public void afterPropertiesSet() throws Exception {
        try {
            Secret tmpSecret;
            ILocator locator = this.getKeyStoreLocator();
            if (locator == null) {
                locator = new FileLocator(this.getKeyStoreFileName());
            }
            IKeyStore keyStore = KeyStoreFactory.get().create(locator);
            if (this.getKeyStorePassword() != null) {
                tmpSecret = this.getKeyStorePassword();
            } else if (this.getKeyStoreKeyProvider() != null) {
                tmpSecret = Secret.hide((byte[])this.getKeyStoreKeyProvider().getBytes());
            } else {
                throw new IllegalArgumentException("secret required");
            }
            keyStore.load(tmpSecret);
            this.certificateProvider = keyStore.getCertificateProvider();
        }
        catch (Exception e) {
            throw new InitializationException("cannot load keystore", (Throwable)e);
        }
        super.afterPropertiesSet();
    }

    protected KeyStoreCertificateProvider createInstance() throws Exception {
        return (KeyStoreCertificateProvider)this.certificateProvider;
    }

    public String getKeyStoreFileName() {
        return this.keyStoreFileName;
    }

    public IByteProvider getKeyStoreKeyProvider() {
        return this.keyStoreKeyProvider;
    }

    public ILocator getKeyStoreLocator() {
        return this.keyStoreLocator;
    }

    public Secret getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public Class<?> getObjectType() {
        return KeyStoreCertificateProvider.class;
    }

    public void setKeyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
    }

    public void setKeyStoreKeyProvider(IByteProvider keyStoreKeyProvider) {
        this.keyStoreKeyProvider = keyStoreKeyProvider;
    }

    public void setKeyStoreLocator(ILocator keyStoreLocator) {
        this.keyStoreLocator = keyStoreLocator;
    }

    public void setKeyStorePassword(Secret keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }
}

